/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH265ReferenceInfoFlags;

public class StdVideoDecodeH265ReferenceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PICORDERCNTVAL;
    public static final int FLAGS;

    public StdVideoDecodeH265ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoDecodeH265ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int PicOrderCntVal() {
        return StdVideoDecodeH265ReferenceInfo.nPicOrderCntVal(this.address());
    }

    public StdVideoDecodeH265ReferenceInfoFlags flags() {
        return StdVideoDecodeH265ReferenceInfo.nflags(this.address());
    }

    public StdVideoDecodeH265ReferenceInfo PicOrderCntVal(@NativeType(value="int32_t") int value) {
        StdVideoDecodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265ReferenceInfo flags(StdVideoDecodeH265ReferenceInfoFlags value) {
        StdVideoDecodeH265ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH265ReferenceInfo flags(Consumer<StdVideoDecodeH265ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH265ReferenceInfo set(int PicOrderCntVal, StdVideoDecodeH265ReferenceInfoFlags flags) {
        this.PicOrderCntVal(PicOrderCntVal);
        this.flags(flags);
        return this;
    }

    public StdVideoDecodeH265ReferenceInfo set(StdVideoDecodeH265ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoDecodeH265ReferenceInfo malloc() {
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoDecodeH265ReferenceInfo calloc() {
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoDecodeH265ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoDecodeH265ReferenceInfo create(long address) {
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, address);
    }

    @Nullable
    public static StdVideoDecodeH265ReferenceInfo createSafe(long address) {
        return address == 0L ? null : StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoDecodeH265ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH265ReferenceInfo.__create(capacity, SIZEOF);
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoDecodeH265ReferenceInfo malloc(MemoryStack stack) {
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoDecodeH265ReferenceInfo calloc(MemoryStack stack) {
        return StdVideoDecodeH265ReferenceInfo.wrap(StdVideoDecodeH265ReferenceInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH265ReferenceInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nPicOrderCntVal(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNTVAL);
    }

    public static StdVideoDecodeH265ReferenceInfoFlags nflags(long struct) {
        return StdVideoDecodeH265ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static void nPicOrderCntVal(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNTVAL, value);
    }

    public static void nflags(long struct, StdVideoDecodeH265ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoDecodeH265ReferenceInfoFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH265ReferenceInfo.__struct(StdVideoDecodeH265ReferenceInfo.__member(4), StdVideoDecodeH265ReferenceInfo.__member(StdVideoDecodeH265ReferenceInfoFlags.SIZEOF, StdVideoDecodeH265ReferenceInfoFlags.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PICORDERCNTVAL = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH265ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH265ReferenceInfo ELEMENT_FACTORY = StdVideoDecodeH265ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoDecodeH265ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int PicOrderCntVal() {
            return StdVideoDecodeH265ReferenceInfo.nPicOrderCntVal(this.address());
        }

        public StdVideoDecodeH265ReferenceInfoFlags flags() {
            return StdVideoDecodeH265ReferenceInfo.nflags(this.address());
        }

        public Buffer PicOrderCntVal(@NativeType(value="int32_t") int value) {
            StdVideoDecodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
            return this;
        }

        public Buffer flags(StdVideoDecodeH265ReferenceInfoFlags value) {
            StdVideoDecodeH265ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH265ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }
    }
}

