/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeH264ReferenceInfoFlags;

public class StdVideoDecodeH264ReferenceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMENUM;
    public static final int RESERVED;
    public static final int PICORDERCNT;
    public static final int FLAGS;

    public StdVideoDecodeH264ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoDecodeH264ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short FrameNum() {
        return StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address());
    }

    @NativeType(value="uint16_t")
    public short reserved() {
        return StdVideoDecodeH264ReferenceInfo.nreserved(this.address());
    }

    @NativeType(value="int32_t[2]")
    public IntBuffer PicOrderCnt() {
        return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt(int index) {
        return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index);
    }

    public StdVideoDecodeH264ReferenceInfoFlags flags() {
        return StdVideoDecodeH264ReferenceInfo.nflags(this.address());
    }

    public StdVideoDecodeH264ReferenceInfo FrameNum(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo reserved(@NativeType(value="uint16_t") short value) {
        StdVideoDecodeH264ReferenceInfo.nreserved(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo PicOrderCnt(@NativeType(value="int32_t[2]") IntBuffer value) {
        StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
        StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo flags(StdVideoDecodeH264ReferenceInfoFlags value) {
        StdVideoDecodeH264ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo flags(Consumer<StdVideoDecodeH264ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo set(short FrameNum, short reserved, IntBuffer PicOrderCnt, StdVideoDecodeH264ReferenceInfoFlags flags) {
        this.FrameNum(FrameNum);
        this.reserved(reserved);
        this.PicOrderCnt(PicOrderCnt);
        this.flags(flags);
        return this;
    }

    public StdVideoDecodeH264ReferenceInfo set(StdVideoDecodeH264ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoDecodeH264ReferenceInfo malloc() {
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoDecodeH264ReferenceInfo calloc() {
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoDecodeH264ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoDecodeH264ReferenceInfo create(long address) {
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, address);
    }

    @Nullable
    public static StdVideoDecodeH264ReferenceInfo createSafe(long address) {
        return address == 0L ? null : StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoDecodeH264ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeH264ReferenceInfo.__create(capacity, SIZEOF);
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoDecodeH264ReferenceInfo malloc(MemoryStack stack) {
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoDecodeH264ReferenceInfo calloc(MemoryStack stack) {
        return StdVideoDecodeH264ReferenceInfo.wrap(StdVideoDecodeH264ReferenceInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoDecodeH264ReferenceInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nFrameNum(long struct) {
        return UNSAFE.getShort(null, struct + (long)FRAMENUM);
    }

    public static short nreserved(long struct) {
        return UNSAFE.getShort(null, struct + (long)RESERVED);
    }

    public static IntBuffer nPicOrderCnt(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)PICORDERCNT, 2);
    }

    public static int nPicOrderCnt(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT + Checks.check(index, 2) * 4L);
    }

    public static StdVideoDecodeH264ReferenceInfoFlags nflags(long struct) {
        return StdVideoDecodeH264ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static void nFrameNum(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)FRAMENUM, value);
    }

    public static void nreserved(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)RESERVED, value);
    }

    public static void nPicOrderCnt(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PICORDERCNT, value.remaining() * 4);
    }

    public static void nPicOrderCnt(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT + Checks.check(index, 2) * 4L, value);
    }

    public static void nflags(long struct, StdVideoDecodeH264ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoDecodeH264ReferenceInfoFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = StdVideoDecodeH264ReferenceInfo.__struct(StdVideoDecodeH264ReferenceInfo.__member(2), StdVideoDecodeH264ReferenceInfo.__member(2), StdVideoDecodeH264ReferenceInfo.__array(4, 2), StdVideoDecodeH264ReferenceInfo.__member(StdVideoDecodeH264ReferenceInfoFlags.SIZEOF, StdVideoDecodeH264ReferenceInfoFlags.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMENUM = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        PICORDERCNT = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeH264ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeH264ReferenceInfo ELEMENT_FACTORY = StdVideoDecodeH264ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoDecodeH264ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short FrameNum() {
            return StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address());
        }

        @NativeType(value="uint16_t")
        public short reserved() {
            return StdVideoDecodeH264ReferenceInfo.nreserved(this.address());
        }

        @NativeType(value="int32_t[2]")
        public IntBuffer PicOrderCnt() {
            return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt(int index) {
            return StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index);
        }

        public StdVideoDecodeH264ReferenceInfoFlags flags() {
            return StdVideoDecodeH264ReferenceInfo.nflags(this.address());
        }

        public Buffer FrameNum(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264ReferenceInfo.nFrameNum(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="uint16_t") short value) {
            StdVideoDecodeH264ReferenceInfo.nreserved(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t[2]") IntBuffer value) {
            StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(int index, @NativeType(value="int32_t") int value) {
            StdVideoDecodeH264ReferenceInfo.nPicOrderCnt(this.address(), index, value);
            return this;
        }

        public Buffer flags(StdVideoDecodeH264ReferenceInfoFlags value) {
            StdVideoDecodeH264ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeH264ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }
    }
}

