/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewportSwizzleNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public VkViewportSwizzleNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkViewportSwizzleNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int x() {
        return VkViewportSwizzleNV.nx(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int y() {
        return VkViewportSwizzleNV.ny(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int z() {
        return VkViewportSwizzleNV.nz(this.address());
    }

    @NativeType(value="VkViewportCoordinateSwizzleNV")
    public int w() {
        return VkViewportSwizzleNV.nw(this.address());
    }

    public VkViewportSwizzleNV x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nx(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.ny(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nz(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
        VkViewportSwizzleNV.nw(this.address(), value);
        return this;
    }

    public VkViewportSwizzleNV set(int x, int y, int z, int w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public VkViewportSwizzleNV set(VkViewportSwizzleNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkViewportSwizzleNV malloc() {
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkViewportSwizzleNV calloc() {
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkViewportSwizzleNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkViewportSwizzleNV create(long address) {
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, address);
    }

    @Nullable
    public static VkViewportSwizzleNV createSafe(long address) {
        return address == 0L ? null : VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkViewportSwizzleNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkViewportSwizzleNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkViewportSwizzleNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkViewportSwizzleNV.__create(capacity, SIZEOF);
        return VkViewportSwizzleNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkViewportSwizzleNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkViewportSwizzleNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkViewportSwizzleNV mallocStack() {
        return VkViewportSwizzleNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportSwizzleNV callocStack() {
        return VkViewportSwizzleNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewportSwizzleNV mallocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.malloc(stack);
    }

    @Deprecated
    public static VkViewportSwizzleNV callocStack(MemoryStack stack) {
        return VkViewportSwizzleNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkViewportSwizzleNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkViewportSwizzleNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.calloc(capacity, stack);
    }

    public static VkViewportSwizzleNV malloc(MemoryStack stack) {
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkViewportSwizzleNV calloc(MemoryStack stack) {
        return VkViewportSwizzleNV.wrap(VkViewportSwizzleNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkViewportSwizzleNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static int nz(long struct) {
        return UNSAFE.getInt(null, struct + (long)Z);
    }

    public static int nw(long struct) {
        return UNSAFE.getInt(null, struct + (long)W);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Z, value);
    }

    public static void nw(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = VkViewportSwizzleNV.__struct(VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4), VkViewportSwizzleNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkViewportSwizzleNV, Buffer>
    implements NativeResource {
        private static final VkViewportSwizzleNV ELEMENT_FACTORY = VkViewportSwizzleNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkViewportSwizzleNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int x() {
            return VkViewportSwizzleNV.nx(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int y() {
            return VkViewportSwizzleNV.ny(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int z() {
            return VkViewportSwizzleNV.nz(this.address());
        }

        @NativeType(value="VkViewportCoordinateSwizzleNV")
        public int w() {
            return VkViewportSwizzleNV.nw(this.address());
        }

        public Buffer x(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nz(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="VkViewportCoordinateSwizzleNV") int value) {
            VkViewportSwizzleNV.nw(this.address(), value);
            return this;
        }
    }
}

