/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoProfileKHR;

public class VkVideoProfilesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROFILECOUNT;
    public static final int PPROFILES;

    public VkVideoProfilesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoProfilesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoProfilesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkVideoProfilesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int profileCount() {
        return VkVideoProfilesKHR.nprofileCount(this.address());
    }

    @NativeType(value="VkVideoProfileKHR const *")
    public VkVideoProfileKHR pProfiles() {
        return VkVideoProfilesKHR.npProfiles(this.address());
    }

    public VkVideoProfilesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoProfilesKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoProfilesKHR sType$Default() {
        return this.sType(1000023013);
    }

    public VkVideoProfilesKHR pNext(@NativeType(value="void *") long value) {
        VkVideoProfilesKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoProfilesKHR profileCount(@NativeType(value="uint32_t") int value) {
        VkVideoProfilesKHR.nprofileCount(this.address(), value);
        return this;
    }

    public VkVideoProfilesKHR pProfiles(@NativeType(value="VkVideoProfileKHR const *") VkVideoProfileKHR value) {
        VkVideoProfilesKHR.npProfiles(this.address(), value);
        return this;
    }

    public VkVideoProfilesKHR set(int sType, long pNext, int profileCount, VkVideoProfileKHR pProfiles) {
        this.sType(sType);
        this.pNext(pNext);
        this.profileCount(profileCount);
        this.pProfiles(pProfiles);
        return this;
    }

    public VkVideoProfilesKHR set(VkVideoProfilesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoProfilesKHR malloc() {
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoProfilesKHR calloc() {
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoProfilesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoProfilesKHR create(long address) {
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, address);
    }

    @Nullable
    public static VkVideoProfilesKHR createSafe(long address) {
        return address == 0L ? null : VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoProfilesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoProfilesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoProfilesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoProfilesKHR.__create(capacity, SIZEOF);
        return VkVideoProfilesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoProfilesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoProfilesKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoProfilesKHR malloc(MemoryStack stack) {
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoProfilesKHR calloc(MemoryStack stack) {
        return VkVideoProfilesKHR.wrap(VkVideoProfilesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoProfilesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoProfilesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprofileCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROFILECOUNT);
    }

    public static VkVideoProfileKHR npProfiles(long struct) {
        return VkVideoProfileKHR.create(MemoryUtil.memGetAddress(struct + (long)PPROFILES));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprofileCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROFILECOUNT, value);
    }

    public static void npProfiles(long struct, VkVideoProfileKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PPROFILES, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PPROFILES));
    }

    static {
        Struct.Layout layout = VkVideoProfilesKHR.__struct(VkVideoProfilesKHR.__member(4), VkVideoProfilesKHR.__member(POINTER_SIZE), VkVideoProfilesKHR.__member(4), VkVideoProfilesKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROFILECOUNT = layout.offsetof(2);
        PPROFILES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkVideoProfilesKHR, Buffer>
    implements NativeResource {
        private static final VkVideoProfilesKHR ELEMENT_FACTORY = VkVideoProfilesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoProfilesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoProfilesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkVideoProfilesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int profileCount() {
            return VkVideoProfilesKHR.nprofileCount(this.address());
        }

        @NativeType(value="VkVideoProfileKHR const *")
        public VkVideoProfileKHR pProfiles() {
            return VkVideoProfilesKHR.npProfiles(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoProfilesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023013);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkVideoProfilesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer profileCount(@NativeType(value="uint32_t") int value) {
            VkVideoProfilesKHR.nprofileCount(this.address(), value);
            return this;
        }

        public Buffer pProfiles(@NativeType(value="VkVideoProfileKHR const *") VkVideoProfileKHR value) {
            VkVideoProfilesKHR.npProfiles(this.address(), value);
            return this;
        }
    }
}

