/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoDecodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH264ProfileEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265ProfileEXT;

public class VkVideoProfileKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIDEOCODECOPERATION;
    public static final int CHROMASUBSAMPLING;
    public static final int LUMABITDEPTH;
    public static final int CHROMABITDEPTH;

    public VkVideoProfileKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoProfileKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoProfileKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkVideoProfileKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoCodecOperationFlagBitsKHR")
    public int videoCodecOperation() {
        return VkVideoProfileKHR.nvideoCodecOperation(this.address());
    }

    @NativeType(value="VkVideoChromaSubsamplingFlagsKHR")
    public int chromaSubsampling() {
        return VkVideoProfileKHR.nchromaSubsampling(this.address());
    }

    @NativeType(value="VkVideoComponentBitDepthFlagsKHR")
    public int lumaBitDepth() {
        return VkVideoProfileKHR.nlumaBitDepth(this.address());
    }

    @NativeType(value="VkVideoComponentBitDepthFlagsKHR")
    public int chromaBitDepth() {
        return VkVideoProfileKHR.nchromaBitDepth(this.address());
    }

    public VkVideoProfileKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoProfileKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR sType$Default() {
        return this.sType(1000023000);
    }

    public VkVideoProfileKHR pNext(@NativeType(value="void *") long value) {
        VkVideoProfileKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR pNext(VkVideoDecodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoProfileKHR pNext(VkVideoDecodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoProfileKHR pNext(VkVideoEncodeH264ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoProfileKHR pNext(VkVideoEncodeH265ProfileEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoProfileKHR videoCodecOperation(@NativeType(value="VkVideoCodecOperationFlagBitsKHR") int value) {
        VkVideoProfileKHR.nvideoCodecOperation(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR chromaSubsampling(@NativeType(value="VkVideoChromaSubsamplingFlagsKHR") int value) {
        VkVideoProfileKHR.nchromaSubsampling(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR lumaBitDepth(@NativeType(value="VkVideoComponentBitDepthFlagsKHR") int value) {
        VkVideoProfileKHR.nlumaBitDepth(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR chromaBitDepth(@NativeType(value="VkVideoComponentBitDepthFlagsKHR") int value) {
        VkVideoProfileKHR.nchromaBitDepth(this.address(), value);
        return this;
    }

    public VkVideoProfileKHR set(int sType, long pNext, int videoCodecOperation, int chromaSubsampling, int lumaBitDepth, int chromaBitDepth) {
        this.sType(sType);
        this.pNext(pNext);
        this.videoCodecOperation(videoCodecOperation);
        this.chromaSubsampling(chromaSubsampling);
        this.lumaBitDepth(lumaBitDepth);
        this.chromaBitDepth(chromaBitDepth);
        return this;
    }

    public VkVideoProfileKHR set(VkVideoProfileKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoProfileKHR malloc() {
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoProfileKHR calloc() {
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoProfileKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoProfileKHR create(long address) {
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, address);
    }

    @Nullable
    public static VkVideoProfileKHR createSafe(long address) {
        return address == 0L ? null : VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoProfileKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoProfileKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoProfileKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoProfileKHR.__create(capacity, SIZEOF);
        return VkVideoProfileKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoProfileKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoProfileKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoProfileKHR malloc(MemoryStack stack) {
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoProfileKHR calloc(MemoryStack stack) {
        return VkVideoProfileKHR.wrap(VkVideoProfileKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoProfileKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoProfileKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nvideoCodecOperation(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIDEOCODECOPERATION);
    }

    public static int nchromaSubsampling(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMASUBSAMPLING);
    }

    public static int nlumaBitDepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)LUMABITDEPTH);
    }

    public static int nchromaBitDepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMABITDEPTH);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nvideoCodecOperation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIDEOCODECOPERATION, value);
    }

    public static void nchromaSubsampling(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMASUBSAMPLING, value);
    }

    public static void nlumaBitDepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LUMABITDEPTH, value);
    }

    public static void nchromaBitDepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMABITDEPTH, value);
    }

    static {
        Struct.Layout layout = VkVideoProfileKHR.__struct(VkVideoProfileKHR.__member(4), VkVideoProfileKHR.__member(POINTER_SIZE), VkVideoProfileKHR.__member(4), VkVideoProfileKHR.__member(4), VkVideoProfileKHR.__member(4), VkVideoProfileKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIDEOCODECOPERATION = layout.offsetof(2);
        CHROMASUBSAMPLING = layout.offsetof(3);
        LUMABITDEPTH = layout.offsetof(4);
        CHROMABITDEPTH = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkVideoProfileKHR, Buffer>
    implements NativeResource {
        private static final VkVideoProfileKHR ELEMENT_FACTORY = VkVideoProfileKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoProfileKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoProfileKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkVideoProfileKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoCodecOperationFlagBitsKHR")
        public int videoCodecOperation() {
            return VkVideoProfileKHR.nvideoCodecOperation(this.address());
        }

        @NativeType(value="VkVideoChromaSubsamplingFlagsKHR")
        public int chromaSubsampling() {
            return VkVideoProfileKHR.nchromaSubsampling(this.address());
        }

        @NativeType(value="VkVideoComponentBitDepthFlagsKHR")
        public int lumaBitDepth() {
            return VkVideoProfileKHR.nlumaBitDepth(this.address());
        }

        @NativeType(value="VkVideoComponentBitDepthFlagsKHR")
        public int chromaBitDepth() {
            return VkVideoProfileKHR.nchromaBitDepth(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoProfileKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkVideoProfileKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265ProfileEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer videoCodecOperation(@NativeType(value="VkVideoCodecOperationFlagBitsKHR") int value) {
            VkVideoProfileKHR.nvideoCodecOperation(this.address(), value);
            return this;
        }

        public Buffer chromaSubsampling(@NativeType(value="VkVideoChromaSubsamplingFlagsKHR") int value) {
            VkVideoProfileKHR.nchromaSubsampling(this.address(), value);
            return this;
        }

        public Buffer lumaBitDepth(@NativeType(value="VkVideoComponentBitDepthFlagsKHR") int value) {
            VkVideoProfileKHR.nlumaBitDepth(this.address(), value);
            return this;
        }

        public Buffer chromaBitDepth(@NativeType(value="VkVideoComponentBitDepthFlagsKHR") int value) {
            VkVideoProfileKHR.nchromaBitDepth(this.address(), value);
            return this;
        }
    }
}

