/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoEncodeH264RateControlInfoEXT;
import org.lwjgl.vulkan.VkVideoEncodeH265RateControlInfoEXT;
import org.lwjgl.vulkan.VkVideoEncodeRateControlLayerInfoKHR;

public class VkVideoEncodeRateControlInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RATECONTROLMODE;
    public static final int LAYERCOUNT;
    public static final int PLAYERCONFIGS;

    public VkVideoEncodeRateControlInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeRateControlInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeRateControlInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeRateControlInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlFlagsKHR")
    public int flags() {
        return VkVideoEncodeRateControlInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR")
    public int rateControlMode() {
        return VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address());
    }

    @NativeType(value="uint8_t")
    public byte layerCount() {
        return VkVideoEncodeRateControlInfoKHR.nlayerCount(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *")
    public VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayerConfigs() {
        return VkVideoEncodeRateControlInfoKHR.npLayerConfigs(this.address());
    }

    public VkVideoEncodeRateControlInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeRateControlInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR sType$Default() {
        return this.sType(1000299001);
    }

    public VkVideoEncodeRateControlInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeRateControlInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR pNext(VkVideoEncodeH264RateControlInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeRateControlInfoKHR pNext(VkVideoEncodeH265RateControlInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeRateControlInfoKHR flags(@NativeType(value="VkVideoEncodeRateControlFlagsKHR") int value) {
        VkVideoEncodeRateControlInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR rateControlMode(@NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR") int value) {
        VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR pLayerConfigs(@NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *") VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
        VkVideoEncodeRateControlInfoKHR.npLayerConfigs(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR set(int sType, long pNext, int flags, int rateControlMode, VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayerConfigs) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.rateControlMode(rateControlMode);
        this.pLayerConfigs(pLayerConfigs);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR set(VkVideoEncodeRateControlInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeRateControlInfoKHR malloc() {
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoEncodeRateControlInfoKHR calloc() {
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoEncodeRateControlInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeRateControlInfoKHR create(long address) {
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, address);
    }

    @Nullable
    public static VkVideoEncodeRateControlInfoKHR createSafe(long address) {
        return address == 0L ? null : VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoEncodeRateControlInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeRateControlInfoKHR.__create(capacity, SIZEOF);
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoEncodeRateControlInfoKHR malloc(MemoryStack stack) {
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoEncodeRateControlInfoKHR calloc(MemoryStack stack) {
        return VkVideoEncodeRateControlInfoKHR.wrap(VkVideoEncodeRateControlInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoEncodeRateControlInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nrateControlMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)RATECONTROLMODE);
    }

    public static byte nlayerCount(long struct) {
        return UNSAFE.getByte(null, struct + (long)LAYERCOUNT);
    }

    public static VkVideoEncodeRateControlLayerInfoKHR.Buffer npLayerConfigs(long struct) {
        return VkVideoEncodeRateControlLayerInfoKHR.create(MemoryUtil.memGetAddress(struct + (long)PLAYERCONFIGS), Byte.toUnsignedInt(VkVideoEncodeRateControlInfoKHR.nlayerCount(struct)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrateControlMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RATECONTROLMODE, value);
    }

    public static void nlayerCount(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LAYERCOUNT, value);
    }

    public static void npLayerConfigs(long struct, VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PLAYERCONFIGS, value.address());
        VkVideoEncodeRateControlInfoKHR.nlayerCount(struct, (byte)value.remaining());
    }

    public static void validate(long struct) {
        byte layerCount = VkVideoEncodeRateControlInfoKHR.nlayerCount(struct);
        long pLayerConfigs = MemoryUtil.memGetAddress(struct + (long)PLAYERCONFIGS);
        Checks.check(pLayerConfigs);
        VkVideoEncodeRateControlInfoKHR.validate(pLayerConfigs, layerCount, VkVideoEncodeRateControlLayerInfoKHR.SIZEOF, VkVideoEncodeRateControlLayerInfoKHR::validate);
    }

    static {
        Struct.Layout layout = VkVideoEncodeRateControlInfoKHR.__struct(VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(POINTER_SIZE), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(1), VkVideoEncodeRateControlInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RATECONTROLMODE = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
        PLAYERCONFIGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeRateControlInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeRateControlInfoKHR ELEMENT_FACTORY = VkVideoEncodeRateControlInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeRateControlInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeRateControlInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeRateControlInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlFlagsKHR")
        public int flags() {
            return VkVideoEncodeRateControlInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR")
        public int rateControlMode() {
            return VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address());
        }

        @NativeType(value="uint8_t")
        public byte layerCount() {
            return VkVideoEncodeRateControlInfoKHR.nlayerCount(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *")
        public VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayerConfigs() {
            return VkVideoEncodeRateControlInfoKHR.npLayerConfigs(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeRateControlInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeRateControlInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeH264RateControlInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265RateControlInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeRateControlFlagsKHR") int value) {
            VkVideoEncodeRateControlInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer rateControlMode(@NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR") int value) {
            VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address(), value);
            return this;
        }

        public Buffer pLayerConfigs(@NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *") VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
            VkVideoEncodeRateControlInfoKHR.npLayerConfigs(this.address(), value);
            return this;
        }
    }
}

