/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoReferenceSlotKHR;

public class VkVideoBeginCodingInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int CODECQUALITYPRESET;
    public static final int VIDEOSESSION;
    public static final int VIDEOSESSIONPARAMETERS;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;

    public VkVideoBeginCodingInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoBeginCodingInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoBeginCodingInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoBeginCodingInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoBeginCodingFlagsKHR")
    public int flags() {
        return VkVideoBeginCodingInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoCodingQualityPresetFlagsKHR")
    public int codecQualityPreset() {
        return VkVideoBeginCodingInfoKHR.ncodecQualityPreset(this.address());
    }

    @NativeType(value="VkVideoSessionKHR")
    public long videoSession() {
        return VkVideoBeginCodingInfoKHR.nvideoSession(this.address());
    }

    @NativeType(value="VkVideoSessionParametersKHR")
    public long videoSessionParameters() {
        return VkVideoBeginCodingInfoKHR.nvideoSessionParameters(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoBeginCodingInfoKHR.nreferenceSlotCount(this.address());
    }

    @Nullable
    @NativeType(value="VkVideoReferenceSlotKHR const *")
    public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
        return VkVideoBeginCodingInfoKHR.npReferenceSlots(this.address());
    }

    public VkVideoBeginCodingInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoBeginCodingInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR sType$Default() {
        return this.sType(1000023008);
    }

    public VkVideoBeginCodingInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoBeginCodingInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR flags(@NativeType(value="VkVideoBeginCodingFlagsKHR") int value) {
        VkVideoBeginCodingInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR codecQualityPreset(@NativeType(value="VkVideoCodingQualityPresetFlagsKHR") int value) {
        VkVideoBeginCodingInfoKHR.ncodecQualityPreset(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR videoSession(@NativeType(value="VkVideoSessionKHR") long value) {
        VkVideoBeginCodingInfoKHR.nvideoSession(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR videoSessionParameters(@NativeType(value="VkVideoSessionParametersKHR") long value) {
        VkVideoBeginCodingInfoKHR.nvideoSessionParameters(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
        VkVideoBeginCodingInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoBeginCodingInfoKHR set(int sType, long pNext, int flags, int codecQualityPreset, long videoSession, long videoSessionParameters, @Nullable VkVideoReferenceSlotKHR.Buffer pReferenceSlots) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.codecQualityPreset(codecQualityPreset);
        this.videoSession(videoSession);
        this.videoSessionParameters(videoSessionParameters);
        this.pReferenceSlots(pReferenceSlots);
        return this;
    }

    public VkVideoBeginCodingInfoKHR set(VkVideoBeginCodingInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoBeginCodingInfoKHR malloc() {
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoBeginCodingInfoKHR calloc() {
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoBeginCodingInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoBeginCodingInfoKHR create(long address) {
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, address);
    }

    @Nullable
    public static VkVideoBeginCodingInfoKHR createSafe(long address) {
        return address == 0L ? null : VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoBeginCodingInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoBeginCodingInfoKHR.__create(capacity, SIZEOF);
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoBeginCodingInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoBeginCodingInfoKHR malloc(MemoryStack stack) {
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoBeginCodingInfoKHR calloc(MemoryStack stack) {
        return VkVideoBeginCodingInfoKHR.wrap(VkVideoBeginCodingInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoBeginCodingInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ncodecQualityPreset(long struct) {
        return UNSAFE.getInt(null, struct + (long)CODECQUALITYPRESET);
    }

    public static long nvideoSession(long struct) {
        return UNSAFE.getLong(null, struct + (long)VIDEOSESSION);
    }

    public static long nvideoSessionParameters(long struct) {
        return UNSAFE.getLong(null, struct + (long)VIDEOSESSIONPARAMETERS);
    }

    public static int nreferenceSlotCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESLOTCOUNT);
    }

    @Nullable
    public static VkVideoReferenceSlotKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS), VkVideoBeginCodingInfoKHR.nreferenceSlotCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ncodecQualityPreset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CODECQUALITYPRESET, value);
    }

    public static void nvideoSession(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VIDEOSESSION, value);
    }

    public static void nvideoSessionParameters(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VIDEOSESSIONPARAMETERS, value);
    }

    public static void nreferenceSlotCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREFERENCESLOTS, MemoryUtil.memAddressSafe(value));
        VkVideoBeginCodingInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int referenceSlotCount = VkVideoBeginCodingInfoKHR.nreferenceSlotCount(struct);
        if (referenceSlotCount != 0) {
            long pReferenceSlots = MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS);
            Checks.check(pReferenceSlots);
            VkVideoBeginCodingInfoKHR.validate(pReferenceSlots, referenceSlotCount, VkVideoReferenceSlotKHR.SIZEOF, VkVideoReferenceSlotKHR::validate);
        }
    }

    static {
        Struct.Layout layout = VkVideoBeginCodingInfoKHR.__struct(VkVideoBeginCodingInfoKHR.__member(4), VkVideoBeginCodingInfoKHR.__member(POINTER_SIZE), VkVideoBeginCodingInfoKHR.__member(4), VkVideoBeginCodingInfoKHR.__member(4), VkVideoBeginCodingInfoKHR.__member(8), VkVideoBeginCodingInfoKHR.__member(8), VkVideoBeginCodingInfoKHR.__member(4), VkVideoBeginCodingInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        CODECQUALITYPRESET = layout.offsetof(3);
        VIDEOSESSION = layout.offsetof(4);
        VIDEOSESSIONPARAMETERS = layout.offsetof(5);
        REFERENCESLOTCOUNT = layout.offsetof(6);
        PREFERENCESLOTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkVideoBeginCodingInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoBeginCodingInfoKHR ELEMENT_FACTORY = VkVideoBeginCodingInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoBeginCodingInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoBeginCodingInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoBeginCodingInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoBeginCodingFlagsKHR")
        public int flags() {
            return VkVideoBeginCodingInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoCodingQualityPresetFlagsKHR")
        public int codecQualityPreset() {
            return VkVideoBeginCodingInfoKHR.ncodecQualityPreset(this.address());
        }

        @NativeType(value="VkVideoSessionKHR")
        public long videoSession() {
            return VkVideoBeginCodingInfoKHR.nvideoSession(this.address());
        }

        @NativeType(value="VkVideoSessionParametersKHR")
        public long videoSessionParameters() {
            return VkVideoBeginCodingInfoKHR.nvideoSessionParameters(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoBeginCodingInfoKHR.nreferenceSlotCount(this.address());
        }

        @Nullable
        @NativeType(value="VkVideoReferenceSlotKHR const *")
        public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
            return VkVideoBeginCodingInfoKHR.npReferenceSlots(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoBeginCodingInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023008);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoBeginCodingInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkVideoBeginCodingFlagsKHR") int value) {
            VkVideoBeginCodingInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer codecQualityPreset(@NativeType(value="VkVideoCodingQualityPresetFlagsKHR") int value) {
            VkVideoBeginCodingInfoKHR.ncodecQualityPreset(this.address(), value);
            return this;
        }

        public Buffer videoSession(@NativeType(value="VkVideoSessionKHR") long value) {
            VkVideoBeginCodingInfoKHR.nvideoSession(this.address(), value);
            return this;
        }

        public Buffer videoSessionParameters(@NativeType(value="VkVideoSessionParametersKHR") long value) {
            VkVideoBeginCodingInfoKHR.nvideoSessionParameters(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
            VkVideoBeginCodingInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }
    }
}

