/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationFeaturesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ENABLEDVALIDATIONFEATURECOUNT;
    public static final int PENABLEDVALIDATIONFEATURES;
    public static final int DISABLEDVALIDATIONFEATURECOUNT;
    public static final int PDISABLEDVALIDATIONFEATURES;

    public VkValidationFeaturesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkValidationFeaturesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkValidationFeaturesEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkValidationFeaturesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledValidationFeatureCount() {
        return VkValidationFeaturesEXT.nenabledValidationFeatureCount(this.address());
    }

    @Nullable
    @NativeType(value="VkValidationFeatureEnableEXT const *")
    public IntBuffer pEnabledValidationFeatures() {
        return VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address());
    }

    @NativeType(value="uint32_t")
    public int disabledValidationFeatureCount() {
        return VkValidationFeaturesEXT.ndisabledValidationFeatureCount(this.address());
    }

    @Nullable
    @NativeType(value="VkValidationFeatureDisableEXT const *")
    public IntBuffer pDisabledValidationFeatures() {
        return VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address());
    }

    public VkValidationFeaturesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkValidationFeaturesEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT sType$Default() {
        return this.sType(1000247000);
    }

    public VkValidationFeaturesEXT pNext(@NativeType(value="void const *") long value) {
        VkValidationFeaturesEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT pEnabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureEnableEXT const *") IntBuffer value) {
        VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT pDisabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureDisableEXT const *") IntBuffer value) {
        VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address(), value);
        return this;
    }

    public VkValidationFeaturesEXT set(int sType, long pNext, @Nullable IntBuffer pEnabledValidationFeatures, @Nullable IntBuffer pDisabledValidationFeatures) {
        this.sType(sType);
        this.pNext(pNext);
        this.pEnabledValidationFeatures(pEnabledValidationFeatures);
        this.pDisabledValidationFeatures(pDisabledValidationFeatures);
        return this;
    }

    public VkValidationFeaturesEXT set(VkValidationFeaturesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkValidationFeaturesEXT malloc() {
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkValidationFeaturesEXT calloc() {
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkValidationFeaturesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkValidationFeaturesEXT create(long address) {
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, address);
    }

    @Nullable
    public static VkValidationFeaturesEXT createSafe(long address) {
        return address == 0L ? null : VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkValidationFeaturesEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkValidationFeaturesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkValidationFeaturesEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkValidationFeaturesEXT.__create(capacity, SIZEOF);
        return VkValidationFeaturesEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkValidationFeaturesEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkValidationFeaturesEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkValidationFeaturesEXT mallocStack() {
        return VkValidationFeaturesEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationFeaturesEXT callocStack() {
        return VkValidationFeaturesEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationFeaturesEXT mallocStack(MemoryStack stack) {
        return VkValidationFeaturesEXT.malloc(stack);
    }

    @Deprecated
    public static VkValidationFeaturesEXT callocStack(MemoryStack stack) {
        return VkValidationFeaturesEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkValidationFeaturesEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkValidationFeaturesEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkValidationFeaturesEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkValidationFeaturesEXT.calloc(capacity, stack);
    }

    public static VkValidationFeaturesEXT malloc(MemoryStack stack) {
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkValidationFeaturesEXT calloc(MemoryStack stack) {
        return VkValidationFeaturesEXT.wrap(VkValidationFeaturesEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkValidationFeaturesEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkValidationFeaturesEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nenabledValidationFeatureCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLEDVALIDATIONFEATURECOUNT);
    }

    @Nullable
    public static IntBuffer npEnabledValidationFeatures(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PENABLEDVALIDATIONFEATURES), VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct));
    }

    public static int ndisabledValidationFeatureCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISABLEDVALIDATIONFEATURECOUNT);
    }

    @Nullable
    public static IntBuffer npDisabledValidationFeatures(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONFEATURES), VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nenabledValidationFeatureCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLEDVALIDATIONFEATURECOUNT, value);
    }

    public static void npEnabledValidationFeatures(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PENABLEDVALIDATIONFEATURES, MemoryUtil.memAddressSafe(value));
        VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndisabledValidationFeatureCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISABLEDVALIDATIONFEATURECOUNT, value);
    }

    public static void npDisabledValidationFeatures(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDISABLEDVALIDATIONFEATURES, MemoryUtil.memAddressSafe(value));
        VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkValidationFeaturesEXT.nenabledValidationFeatureCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PENABLEDVALIDATIONFEATURES));
        }
        if (VkValidationFeaturesEXT.ndisabledValidationFeatureCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONFEATURES));
        }
    }

    static {
        Struct.Layout layout = VkValidationFeaturesEXT.__struct(VkValidationFeaturesEXT.__member(4), VkValidationFeaturesEXT.__member(POINTER_SIZE), VkValidationFeaturesEXT.__member(4), VkValidationFeaturesEXT.__member(POINTER_SIZE), VkValidationFeaturesEXT.__member(4), VkValidationFeaturesEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ENABLEDVALIDATIONFEATURECOUNT = layout.offsetof(2);
        PENABLEDVALIDATIONFEATURES = layout.offsetof(3);
        DISABLEDVALIDATIONFEATURECOUNT = layout.offsetof(4);
        PDISABLEDVALIDATIONFEATURES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkValidationFeaturesEXT, Buffer>
    implements NativeResource {
        private static final VkValidationFeaturesEXT ELEMENT_FACTORY = VkValidationFeaturesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkValidationFeaturesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkValidationFeaturesEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkValidationFeaturesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledValidationFeatureCount() {
            return VkValidationFeaturesEXT.nenabledValidationFeatureCount(this.address());
        }

        @Nullable
        @NativeType(value="VkValidationFeatureEnableEXT const *")
        public IntBuffer pEnabledValidationFeatures() {
            return VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address());
        }

        @NativeType(value="uint32_t")
        public int disabledValidationFeatureCount() {
            return VkValidationFeaturesEXT.ndisabledValidationFeatureCount(this.address());
        }

        @Nullable
        @NativeType(value="VkValidationFeatureDisableEXT const *")
        public IntBuffer pDisabledValidationFeatures() {
            return VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkValidationFeaturesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000247000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkValidationFeaturesEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pEnabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureEnableEXT const *") IntBuffer value) {
            VkValidationFeaturesEXT.npEnabledValidationFeatures(this.address(), value);
            return this;
        }

        public Buffer pDisabledValidationFeatures(@Nullable @NativeType(value="VkValidationFeatureDisableEXT const *") IntBuffer value) {
            VkValidationFeaturesEXT.npDisabledValidationFeatures(this.address(), value);
            return this;
        }
    }
}

