/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSubpassEndInfo;

public class VkSubpassEndInfoKHR
extends VkSubpassEndInfo {
    public VkSubpassEndInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkSubpassEndInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassEndInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassEndInfoKHR sType$Default() {
        return this.sType(1000109006);
    }

    @Override
    public VkSubpassEndInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassEndInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassEndInfoKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubpassEndInfoKHR set(VkSubpassEndInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassEndInfoKHR malloc() {
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassEndInfoKHR calloc() {
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassEndInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassEndInfoKHR create(long address) {
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, address);
    }

    @Nullable
    public static VkSubpassEndInfoKHR createSafe(long address) {
        return address == 0L ? null : VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassEndInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSubpassEndInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassEndInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassEndInfoKHR.__create(capacity, SIZEOF);
        return VkSubpassEndInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSubpassEndInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassEndInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSubpassEndInfoKHR mallocStack() {
        return VkSubpassEndInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassEndInfoKHR callocStack() {
        return VkSubpassEndInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassEndInfoKHR mallocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkSubpassEndInfoKHR callocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassEndInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassEndInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.calloc(capacity, stack);
    }

    public static VkSubpassEndInfoKHR malloc(MemoryStack stack) {
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassEndInfoKHR calloc(MemoryStack stack) {
        return VkSubpassEndInfoKHR.wrap(VkSubpassEndInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkSubpassEndInfo.Buffer {
        private static final VkSubpassEndInfoKHR ELEMENT_FACTORY = VkSubpassEndInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubpassEndInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassEndInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000109006);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassEndInfoKHR.npNext(this.address(), value);
            return this;
        }
    }
}

