/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CONTENTS;

    public VkSubpassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubpassBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkSubpassContents")
    public int contents() {
        return VkSubpassBeginInfo.ncontents(this.address());
    }

    public VkSubpassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo sType$Default() {
        return this.sType(1000109005);
    }

    public VkSubpassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfo.ncontents(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfo set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfo set(VkSubpassBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfo malloc() {
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubpassBeginInfo calloc() {
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubpassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassBeginInfo create(long address) {
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, address);
    }

    @Nullable
    public static VkSubpassBeginInfo createSafe(long address) {
        return address == 0L ? null : VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubpassBeginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSubpassBeginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubpassBeginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassBeginInfo.__create(capacity, SIZEOF);
        return VkSubpassBeginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSubpassBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubpassBeginInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkSubpassBeginInfo malloc(MemoryStack stack) {
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassBeginInfo calloc(MemoryStack stack) {
        return VkSubpassBeginInfo.wrap(VkSubpassBeginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSubpassBeginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncontents(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncontents(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONTENTS, value);
    }

    static {
        Struct.Layout layout = VkSubpassBeginInfo.__struct(VkSubpassBeginInfo.__member(4), VkSubpassBeginInfo.__member(POINTER_SIZE), VkSubpassBeginInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CONTENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkSubpassBeginInfo ELEMENT_FACTORY = VkSubpassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubpassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkSubpassContents")
        public int contents() {
            return VkSubpassBeginInfo.ncontents(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000109005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfo.ncontents(this.address(), value);
            return this;
        }
    }
}

