/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfo;

public class VkRenderPassMultiviewCreateInfoKHR
extends VkRenderPassMultiviewCreateInfo {
    public VkRenderPassMultiviewCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType$Default() {
        return this.sType(1000053000);
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHR set(VkRenderPassMultiviewCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc() {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc() {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkRenderPassMultiviewCreateInfoKHR create(long address) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkRenderPassMultiviewCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkRenderPassMultiviewCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassMultiviewCreateInfoKHR.__create(capacity, SIZEOF);
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR mallocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR callocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(VkRenderPassMultiviewCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkRenderPassMultiviewCreateInfo.Buffer {
        private static final VkRenderPassMultiviewCreateInfoKHR ELEMENT_FACTORY = VkRenderPassMultiviewCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderPassMultiviewCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000053000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewOffsets(@Nullable @NativeType(value="int32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCorrelationMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

