/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineCoverageModulationStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineCoverageReductionStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineCoverageToColorStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineSampleLocationsStateCreateInfoEXT;

public class VkPipelineMultisampleStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RASTERIZATIONSAMPLES;
    public static final int SAMPLESHADINGENABLE;
    public static final int MINSAMPLESHADING;
    public static final int PSAMPLEMASK;
    public static final int ALPHATOCOVERAGEENABLE;
    public static final int ALPHATOONEENABLE;

    public VkPipelineMultisampleStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineMultisampleStateCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineMultisampleStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineMultisampleStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineMultisampleStateCreateFlags")
    public int flags() {
        return VkPipelineMultisampleStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int rasterizationSamples() {
        return VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean sampleShadingEnable() {
        return VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address()) != 0;
    }

    public float minSampleShading() {
        return VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address());
    }

    @Nullable
    @NativeType(value="VkSampleMask const *")
    public IntBuffer pSampleMask(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), capacity);
    }

    @NativeType(value="VkBool32")
    public boolean alphaToCoverageEnable() {
        return VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean alphaToOneEnable() {
        return VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address()) != 0;
    }

    public VkPipelineMultisampleStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineMultisampleStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo sType$Default() {
        return this.sType(24);
    }

    public VkPipelineMultisampleStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineMultisampleStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo pNext(VkPipelineCoverageModulationStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineMultisampleStateCreateInfo pNext(VkPipelineCoverageReductionStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineMultisampleStateCreateInfo pNext(VkPipelineCoverageToColorStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineMultisampleStateCreateInfo pNext(VkPipelineSampleLocationsStateCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineMultisampleStateCreateInfo flags(@NativeType(value="VkPipelineMultisampleStateCreateFlags") int value) {
        VkPipelineMultisampleStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo rasterizationSamples(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo sampleShadingEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo minSampleShading(float value) {
        VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo pSampleMask(@Nullable @NativeType(value="VkSampleMask const *") IntBuffer value) {
        VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), value);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo alphaToCoverageEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo alphaToOneEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo set(int sType, long pNext, int flags, int rasterizationSamples, boolean sampleShadingEnable, float minSampleShading, @Nullable IntBuffer pSampleMask, boolean alphaToCoverageEnable, boolean alphaToOneEnable) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.rasterizationSamples(rasterizationSamples);
        this.sampleShadingEnable(sampleShadingEnable);
        this.minSampleShading(minSampleShading);
        this.pSampleMask(pSampleMask);
        this.alphaToCoverageEnable(alphaToCoverageEnable);
        this.alphaToOneEnable(alphaToOneEnable);
        return this;
    }

    public VkPipelineMultisampleStateCreateInfo set(VkPipelineMultisampleStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineMultisampleStateCreateInfo malloc() {
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo calloc() {
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineMultisampleStateCreateInfo create(long address) {
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, address);
    }

    @Nullable
    public static VkPipelineMultisampleStateCreateInfo createSafe(long address) {
        return address == 0L ? null : VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineMultisampleStateCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineMultisampleStateCreateInfo.__create(capacity, SIZEOF);
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPipelineMultisampleStateCreateInfo mallocStack() {
        return VkPipelineMultisampleStateCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineMultisampleStateCreateInfo callocStack() {
        return VkPipelineMultisampleStateCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineMultisampleStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineMultisampleStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineMultisampleStateCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineMultisampleStateCreateInfo malloc(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineMultisampleStateCreateInfo calloc(MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.wrap(VkPipelineMultisampleStateCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineMultisampleStateCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nrasterizationSamples(long struct) {
        return UNSAFE.getInt(null, struct + (long)RASTERIZATIONSAMPLES);
    }

    public static int nsampleShadingEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLESHADINGENABLE);
    }

    public static float nminSampleShading(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINSAMPLESHADING);
    }

    @Nullable
    public static IntBuffer npSampleMask(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PSAMPLEMASK), capacity);
    }

    public static int nalphaToCoverageEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALPHATOCOVERAGEENABLE);
    }

    public static int nalphaToOneEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALPHATOONEENABLE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrasterizationSamples(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RASTERIZATIONSAMPLES, value);
    }

    public static void nsampleShadingEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLESHADINGENABLE, value);
    }

    public static void nminSampleShading(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINSAMPLESHADING, value);
    }

    public static void npSampleMask(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSAMPLEMASK, MemoryUtil.memAddressSafe(value));
    }

    public static void nalphaToCoverageEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALPHATOCOVERAGEENABLE, value);
    }

    public static void nalphaToOneEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALPHATOONEENABLE, value);
    }

    static {
        Struct.Layout layout = VkPipelineMultisampleStateCreateInfo.__struct(VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(POINTER_SIZE), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(POINTER_SIZE), VkPipelineMultisampleStateCreateInfo.__member(4), VkPipelineMultisampleStateCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RASTERIZATIONSAMPLES = layout.offsetof(3);
        SAMPLESHADINGENABLE = layout.offsetof(4);
        MINSAMPLESHADING = layout.offsetof(5);
        PSAMPLEMASK = layout.offsetof(6);
        ALPHATOCOVERAGEENABLE = layout.offsetof(7);
        ALPHATOONEENABLE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineMultisampleStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineMultisampleStateCreateInfo ELEMENT_FACTORY = VkPipelineMultisampleStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineMultisampleStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineMultisampleStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineMultisampleStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineMultisampleStateCreateFlags")
        public int flags() {
            return VkPipelineMultisampleStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int rasterizationSamples() {
            return VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean sampleShadingEnable() {
            return VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address()) != 0;
        }

        public float minSampleShading() {
            return VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address());
        }

        @Nullable
        @NativeType(value="VkSampleMask const *")
        public IntBuffer pSampleMask(int capacity) {
            return VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), capacity);
        }

        @NativeType(value="VkBool32")
        public boolean alphaToCoverageEnable() {
            return VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean alphaToOneEnable() {
            return VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineMultisampleStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(24);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineMultisampleStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineCoverageModulationStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCoverageReductionStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCoverageToColorStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineSampleLocationsStateCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineMultisampleStateCreateFlags") int value) {
            VkPipelineMultisampleStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer rasterizationSamples(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkPipelineMultisampleStateCreateInfo.nrasterizationSamples(this.address(), value);
            return this;
        }

        public Buffer sampleShadingEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineMultisampleStateCreateInfo.nsampleShadingEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer minSampleShading(float value) {
            VkPipelineMultisampleStateCreateInfo.nminSampleShading(this.address(), value);
            return this;
        }

        public Buffer pSampleMask(@Nullable @NativeType(value="VkSampleMask const *") IntBuffer value) {
            VkPipelineMultisampleStateCreateInfo.npSampleMask(this.address(), value);
            return this;
        }

        public Buffer alphaToCoverageEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineMultisampleStateCreateInfo.nalphaToCoverageEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer alphaToOneEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineMultisampleStateCreateInfo.nalphaToOneEnable(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

