/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkPipelineFragmentShadingRateStateCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FRAGMENTSIZE;
    public static final int COMBINEROPS;

    public VkPipelineFragmentShadingRateStateCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineFragmentShadingRateStateCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address());
    }

    public VkExtent2D fragmentSize() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address());
    }

    @NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]")
    public IntBuffer combinerOps() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address());
    }

    @NativeType(value="VkFragmentShadingRateCombinerOpKHR")
    public int combinerOps(int index) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index);
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR sType$Default() {
        return this.sType(1000226001);
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR fragmentSize(VkExtent2D value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR fragmentSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.fragmentSize());
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR combinerOps(@NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]") IntBuffer value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR combinerOps(int index, @NativeType(value="VkFragmentShadingRateCombinerOpKHR") int value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index, value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR set(int sType, long pNext, VkExtent2D fragmentSize, IntBuffer combinerOps) {
        this.sType(sType);
        this.pNext(pNext);
        this.fragmentSize(fragmentSize);
        this.combinerOps(combinerOps);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR set(VkPipelineFragmentShadingRateStateCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR malloc() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR calloc() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR create(long address) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkPipelineFragmentShadingRateStateCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPipelineFragmentShadingRateStateCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineFragmentShadingRateStateCreateInfoKHR.__create(capacity, SIZEOF);
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR malloc(MemoryStack stack) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR calloc(MemoryStack stack) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(VkPipelineFragmentShadingRateStateCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkExtent2D nfragmentSize(long struct) {
        return VkExtent2D.create(struct + (long)FRAGMENTSIZE);
    }

    public static IntBuffer ncombinerOps(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)COMBINEROPS, 2);
    }

    public static int ncombinerOps(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)COMBINEROPS + Checks.check(index, 2) * 4L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nfragmentSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FRAGMENTSIZE, VkExtent2D.SIZEOF);
    }

    public static void ncombinerOps(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COMBINEROPS, value.remaining() * 4);
    }

    public static void ncombinerOps(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)COMBINEROPS + Checks.check(index, 2) * 4L, value);
    }

    static {
        Struct.Layout layout = VkPipelineFragmentShadingRateStateCreateInfoKHR.__struct(VkPipelineFragmentShadingRateStateCreateInfoKHR.__member(4), VkPipelineFragmentShadingRateStateCreateInfoKHR.__member(POINTER_SIZE), VkPipelineFragmentShadingRateStateCreateInfoKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkPipelineFragmentShadingRateStateCreateInfoKHR.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FRAGMENTSIZE = layout.offsetof(2);
        COMBINEROPS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineFragmentShadingRateStateCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineFragmentShadingRateStateCreateInfoKHR ELEMENT_FACTORY = VkPipelineFragmentShadingRateStateCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineFragmentShadingRateStateCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address());
        }

        public VkExtent2D fragmentSize() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address());
        }

        @NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]")
        public IntBuffer combinerOps() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address());
        }

        @NativeType(value="VkFragmentShadingRateCombinerOpKHR")
        public int combinerOps(int index) {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000226001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer fragmentSize(VkExtent2D value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address(), value);
            return this;
        }

        public Buffer fragmentSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.fragmentSize());
            return this;
        }

        public Buffer combinerOps(@NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]") IntBuffer value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), value);
            return this;
        }

        public Buffer combinerOps(int index, @NativeType(value="VkFragmentShadingRateCombinerOpKHR") int value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index, value);
            return this;
        }
    }
}

