/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceLimits;
import org.lwjgl.vulkan.VkPhysicalDeviceSparseProperties;

public class VkPhysicalDeviceProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int APIVERSION;
    public static final int DRIVERVERSION;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int DEVICETYPE;
    public static final int DEVICENAME;
    public static final int PIPELINECACHEUUID;
    public static final int LIMITS;
    public static final int SPARSEPROPERTIES;

    public VkPhysicalDeviceProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int apiVersion() {
        return VkPhysicalDeviceProperties.napiVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int driverVersion() {
        return VkPhysicalDeviceProperties.ndriverVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorID() {
        return VkPhysicalDeviceProperties.nvendorID(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceID() {
        return VkPhysicalDeviceProperties.ndeviceID(this.address());
    }

    @NativeType(value="VkPhysicalDeviceType")
    public int deviceType() {
        return VkPhysicalDeviceProperties.ndeviceType(this.address());
    }

    @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
    public ByteBuffer deviceName() {
        return VkPhysicalDeviceProperties.ndeviceName(this.address());
    }

    @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
    public String deviceNameString() {
        return VkPhysicalDeviceProperties.ndeviceNameString(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer pipelineCacheUUID() {
        return VkPhysicalDeviceProperties.npipelineCacheUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pipelineCacheUUID(int index) {
        return VkPhysicalDeviceProperties.npipelineCacheUUID(this.address(), index);
    }

    public VkPhysicalDeviceLimits limits() {
        return VkPhysicalDeviceProperties.nlimits(this.address());
    }

    public VkPhysicalDeviceSparseProperties sparseProperties() {
        return VkPhysicalDeviceProperties.nsparseProperties(this.address());
    }

    public static VkPhysicalDeviceProperties malloc() {
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceProperties calloc() {
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceProperties create(long address) {
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, address);
    }

    @Nullable
    public static VkPhysicalDeviceProperties createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPhysicalDeviceProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceProperties.__create(capacity, SIZEOF);
        return VkPhysicalDeviceProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPhysicalDeviceProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceProperties.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceProperties mallocStack() {
        return VkPhysicalDeviceProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProperties callocStack() {
        return VkPhysicalDeviceProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceProperties malloc(MemoryStack stack) {
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProperties calloc(MemoryStack stack) {
        return VkPhysicalDeviceProperties.wrap(VkPhysicalDeviceProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int napiVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)APIVERSION);
    }

    public static int ndriverVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERVERSION);
    }

    public static int nvendorID(long struct) {
        return UNSAFE.getInt(null, struct + (long)VENDORID);
    }

    public static int ndeviceID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEID);
    }

    public static int ndeviceType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICETYPE);
    }

    public static ByteBuffer ndeviceName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICENAME, 256);
    }

    public static String ndeviceNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DEVICENAME);
    }

    public static ByteBuffer npipelineCacheUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PIPELINECACHEUUID, 16);
    }

    public static byte npipelineCacheUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)PIPELINECACHEUUID + Checks.check(index, 16) * 1L);
    }

    public static VkPhysicalDeviceLimits nlimits(long struct) {
        return VkPhysicalDeviceLimits.create(struct + (long)LIMITS);
    }

    public static VkPhysicalDeviceSparseProperties nsparseProperties(long struct) {
        return VkPhysicalDeviceSparseProperties.create(struct + (long)SPARSEPROPERTIES);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProperties.__struct(VkPhysicalDeviceProperties.__member(4), VkPhysicalDeviceProperties.__member(4), VkPhysicalDeviceProperties.__member(4), VkPhysicalDeviceProperties.__member(4), VkPhysicalDeviceProperties.__member(4), VkPhysicalDeviceProperties.__array(1, 256), VkPhysicalDeviceProperties.__array(1, 16), VkPhysicalDeviceProperties.__member(VkPhysicalDeviceLimits.SIZEOF, VkPhysicalDeviceLimits.ALIGNOF), VkPhysicalDeviceProperties.__member(VkPhysicalDeviceSparseProperties.SIZEOF, VkPhysicalDeviceSparseProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        APIVERSION = layout.offsetof(0);
        DRIVERVERSION = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        DEVICETYPE = layout.offsetof(4);
        DEVICENAME = layout.offsetof(5);
        PIPELINECACHEUUID = layout.offsetof(6);
        LIMITS = layout.offsetof(7);
        SPARSEPROPERTIES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceProperties ELEMENT_FACTORY = VkPhysicalDeviceProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int apiVersion() {
            return VkPhysicalDeviceProperties.napiVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int driverVersion() {
            return VkPhysicalDeviceProperties.ndriverVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorID() {
            return VkPhysicalDeviceProperties.nvendorID(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceID() {
            return VkPhysicalDeviceProperties.ndeviceID(this.address());
        }

        @NativeType(value="VkPhysicalDeviceType")
        public int deviceType() {
            return VkPhysicalDeviceProperties.ndeviceType(this.address());
        }

        @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
        public ByteBuffer deviceName() {
            return VkPhysicalDeviceProperties.ndeviceName(this.address());
        }

        @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
        public String deviceNameString() {
            return VkPhysicalDeviceProperties.ndeviceNameString(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer pipelineCacheUUID() {
            return VkPhysicalDeviceProperties.npipelineCacheUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pipelineCacheUUID(int index) {
            return VkPhysicalDeviceProperties.npipelineCacheUUID(this.address(), index);
        }

        public VkPhysicalDeviceLimits limits() {
            return VkPhysicalDeviceProperties.nlimits(this.address());
        }

        public VkPhysicalDeviceSparseProperties sparseProperties() {
            return VkPhysicalDeviceProperties.nsparseProperties(this.address());
        }
    }
}

