/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryPriorityAllocateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRIORITY;

    public VkMemoryPriorityAllocateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryPriorityAllocateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryPriorityAllocateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryPriorityAllocateInfoEXT.npNext(this.address());
    }

    public float priority() {
        return VkMemoryPriorityAllocateInfoEXT.npriority(this.address());
    }

    public VkMemoryPriorityAllocateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryPriorityAllocateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT sType$Default() {
        return this.sType(1000238001);
    }

    public VkMemoryPriorityAllocateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMemoryPriorityAllocateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT priority(float value) {
        VkMemoryPriorityAllocateInfoEXT.npriority(this.address(), value);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT set(int sType, long pNext, float priority) {
        this.sType(sType);
        this.pNext(pNext);
        this.priority(priority);
        return this;
    }

    public VkMemoryPriorityAllocateInfoEXT set(VkMemoryPriorityAllocateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryPriorityAllocateInfoEXT malloc() {
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryPriorityAllocateInfoEXT calloc() {
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryPriorityAllocateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryPriorityAllocateInfoEXT create(long address) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, address);
    }

    @Nullable
    public static VkMemoryPriorityAllocateInfoEXT createSafe(long address) {
        return address == 0L ? null : VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryPriorityAllocateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryPriorityAllocateInfoEXT.__create(capacity, SIZEOF);
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT mallocStack() {
        return VkMemoryPriorityAllocateInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT callocStack() {
        return VkMemoryPriorityAllocateInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT mallocStack(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkMemoryPriorityAllocateInfoEXT callocStack(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.calloc(capacity, stack);
    }

    public static VkMemoryPriorityAllocateInfoEXT malloc(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryPriorityAllocateInfoEXT calloc(MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(VkMemoryPriorityAllocateInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryPriorityAllocateInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static float npriority(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PRIORITY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npriority(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)PRIORITY, value);
    }

    static {
        Struct.Layout layout = VkMemoryPriorityAllocateInfoEXT.__struct(VkMemoryPriorityAllocateInfoEXT.__member(4), VkMemoryPriorityAllocateInfoEXT.__member(POINTER_SIZE), VkMemoryPriorityAllocateInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRIORITY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryPriorityAllocateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryPriorityAllocateInfoEXT ELEMENT_FACTORY = VkMemoryPriorityAllocateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryPriorityAllocateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryPriorityAllocateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryPriorityAllocateInfoEXT.npNext(this.address());
        }

        public float priority() {
            return VkMemoryPriorityAllocateInfoEXT.npriority(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryPriorityAllocateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000238001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryPriorityAllocateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer priority(float value) {
            VkMemoryPriorityAllocateInfoEXT.npriority(this.address(), value);
            return this;
        }
    }
}

