/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryOpaqueCaptureAddressAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OPAQUECAPTUREADDRESS;

    public VkMemoryOpaqueCaptureAddressAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryOpaqueCaptureAddressAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address());
    }

    @NativeType(value="uint64_t")
    public long opaqueCaptureAddress() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address());
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo sType$Default() {
        return this.sType(1000257003);
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo set(VkMemoryOpaqueCaptureAddressAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo malloc() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo calloc() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo create(long address) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, address);
    }

    @Nullable
    public static VkMemoryOpaqueCaptureAddressAllocateInfo createSafe(long address) {
        return address == 0L ? null : VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryOpaqueCaptureAddressAllocateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryOpaqueCaptureAddressAllocateInfo.__create(capacity, SIZEOF);
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo malloc(MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo calloc(MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(VkMemoryOpaqueCaptureAddressAllocateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nopaqueCaptureAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)OPAQUECAPTUREADDRESS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nopaqueCaptureAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OPAQUECAPTUREADDRESS, value);
    }

    static {
        Struct.Layout layout = VkMemoryOpaqueCaptureAddressAllocateInfo.__struct(VkMemoryOpaqueCaptureAddressAllocateInfo.__member(4), VkMemoryOpaqueCaptureAddressAllocateInfo.__member(POINTER_SIZE), VkMemoryOpaqueCaptureAddressAllocateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OPAQUECAPTUREADDRESS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryOpaqueCaptureAddressAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryOpaqueCaptureAddressAllocateInfo ELEMENT_FACTORY = VkMemoryOpaqueCaptureAddressAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryOpaqueCaptureAddressAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address());
        }

        @NativeType(value="uint64_t")
        public long opaqueCaptureAddress() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000257003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

