/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryDedicatedRequirements;

public class VkMemoryDedicatedRequirementsKHR
extends VkMemoryDedicatedRequirements {
    public VkMemoryDedicatedRequirementsKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryDedicatedRequirementsKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedRequirementsKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedRequirementsKHR sType$Default() {
        return this.sType(1000127000);
    }

    @Override
    public VkMemoryDedicatedRequirementsKHR pNext(@NativeType(value="void *") long value) {
        VkMemoryDedicatedRequirementsKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedRequirementsKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryDedicatedRequirementsKHR set(VkMemoryDedicatedRequirementsKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedRequirementsKHR malloc() {
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryDedicatedRequirementsKHR calloc() {
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryDedicatedRequirementsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryDedicatedRequirementsKHR create(long address) {
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, address);
    }

    @Nullable
    public static VkMemoryDedicatedRequirementsKHR createSafe(long address) {
        return address == 0L ? null : VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryDedicatedRequirementsKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedRequirementsKHR.__create(capacity, SIZEOF);
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryDedicatedRequirementsKHR mallocStack() {
        return VkMemoryDedicatedRequirementsKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedRequirementsKHR callocStack() {
        return VkMemoryDedicatedRequirementsKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedRequirementsKHR mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryDedicatedRequirementsKHR callocStack(MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedRequirementsKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedRequirementsKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.calloc(capacity, stack);
    }

    public static VkMemoryDedicatedRequirementsKHR malloc(MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryDedicatedRequirementsKHR calloc(MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.wrap(VkMemoryDedicatedRequirementsKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirementsKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryDedicatedRequirements.Buffer {
        private static final VkMemoryDedicatedRequirementsKHR ELEMENT_FACTORY = VkMemoryDedicatedRequirementsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryDedicatedRequirementsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedRequirementsKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000127000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryDedicatedRequirementsKHR.npNext(this.address(), value);
            return this;
        }
    }
}

