/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateFlagsInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEVICEMASK;

    public VkMemoryAllocateFlagsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryAllocateFlagsInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateFlagsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateFlagsInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryAllocateFlags")
    public int flags() {
        return VkMemoryAllocateFlagsInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
    }

    public VkMemoryAllocateFlagsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo sType$Default() {
        return this.sType(1000060000);
    }

    public VkMemoryAllocateFlagsInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(VkMemoryAllocateFlagsInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfo malloc() {
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo calloc() {
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryAllocateFlagsInfo create(long address) {
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, address);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfo createSafe(long address) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryAllocateFlagsInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateFlagsInfo.__create(capacity, SIZEOF);
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryAllocateFlagsInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo mallocStack() {
        return VkMemoryAllocateFlagsInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo callocStack() {
        return VkMemoryAllocateFlagsInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.malloc(stack);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.calloc(capacity, stack);
    }

    public static VkMemoryAllocateFlagsInfo malloc(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfo calloc(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.wrap(VkMemoryAllocateFlagsInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndeviceMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndeviceMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateFlagsInfo.__struct(VkMemoryAllocateFlagsInfo.__member(4), VkMemoryAllocateFlagsInfo.__member(POINTER_SIZE), VkMemoryAllocateFlagsInfo.__member(4), VkMemoryAllocateFlagsInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateFlagsInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryAllocateFlagsInfo ELEMENT_FACTORY = VkMemoryAllocateFlagsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryAllocateFlagsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateFlagsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateFlagsInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryAllocateFlags")
        public int flags() {
            return VkMemoryAllocateFlagsInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

