/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresourceLayers
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int MIPLEVEL;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    public VkImageSubresourceLayers(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageSubresourceLayers.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkImageSubresourceLayers.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipLevel() {
        return VkImageSubresourceLayers.nmipLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkImageSubresourceLayers.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkImageSubresourceLayers.nlayerCount(this.address());
    }

    public VkImageSubresourceLayers aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkImageSubresourceLayers.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers mipLevel(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceLayers.nmipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceLayers.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers layerCount(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceLayers.nlayerCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceLayers set(int aspectMask, int mipLevel, int baseArrayLayer, int layerCount) {
        this.aspectMask(aspectMask);
        this.mipLevel(mipLevel);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkImageSubresourceLayers set(VkImageSubresourceLayers src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageSubresourceLayers malloc() {
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageSubresourceLayers calloc() {
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageSubresourceLayers create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImageSubresourceLayers create(long address) {
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, address);
    }

    @Nullable
    public static VkImageSubresourceLayers createSafe(long address) {
        return address == 0L ? null : VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageSubresourceLayers.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImageSubresourceLayers.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageSubresourceLayers.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresourceLayers.__create(capacity, SIZEOF);
        return VkImageSubresourceLayers.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImageSubresourceLayers.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageSubresourceLayers.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImageSubresourceLayers mallocStack() {
        return VkImageSubresourceLayers.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresourceLayers callocStack() {
        return VkImageSubresourceLayers.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresourceLayers mallocStack(MemoryStack stack) {
        return VkImageSubresourceLayers.malloc(stack);
    }

    @Deprecated
    public static VkImageSubresourceLayers callocStack(MemoryStack stack) {
        return VkImageSubresourceLayers.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageSubresourceLayers.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageSubresourceLayers.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.calloc(capacity, stack);
    }

    public static VkImageSubresourceLayers malloc(MemoryStack stack) {
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresourceLayers calloc(MemoryStack stack) {
        return VkImageSubresourceLayers.wrap(VkImageSubresourceLayers.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImageSubresourceLayers.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static int nmipLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPLEVEL);
    }

    public static int nbaseArrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    public static void nmipLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPLEVEL, value);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkImageSubresourceLayers.__struct(VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4), VkImageSubresourceLayers.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        MIPLEVEL = layout.offsetof(1);
        BASEARRAYLAYER = layout.offsetof(2);
        LAYERCOUNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresourceLayers, Buffer>
    implements NativeResource {
        private static final VkImageSubresourceLayers ELEMENT_FACTORY = VkImageSubresourceLayers.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageSubresourceLayers getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkImageSubresourceLayers.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipLevel() {
            return VkImageSubresourceLayers.nmipLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkImageSubresourceLayers.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkImageSubresourceLayers.nlayerCount(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkImageSubresourceLayers.naspectMask(this.address(), value);
            return this;
        }

        public Buffer mipLevel(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceLayers.nmipLevel(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceLayers.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceLayers.nlayerCount(this.address(), value);
            return this;
        }
    }
}

