/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFramebufferAttachmentImageInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int USAGE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYERCOUNT;
    public static final int VIEWFORMATCOUNT;
    public static final int PVIEWFORMATS;

    public VkFramebufferAttachmentImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFramebufferAttachmentImageInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFramebufferAttachmentImageInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFramebufferAttachmentImageInfo.npNext(this.address());
    }

    @NativeType(value="VkImageCreateFlags")
    public int flags() {
        return VkFramebufferAttachmentImageInfo.nflags(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int usage() {
        return VkFramebufferAttachmentImageInfo.nusage(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkFramebufferAttachmentImageInfo.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkFramebufferAttachmentImageInfo.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkFramebufferAttachmentImageInfo.nlayerCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewFormatCount() {
        return VkFramebufferAttachmentImageInfo.nviewFormatCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pViewFormats() {
        return VkFramebufferAttachmentImageInfo.npViewFormats(this.address());
    }

    public VkFramebufferAttachmentImageInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFramebufferAttachmentImageInfo.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo sType$Default() {
        return this.sType(1000108002);
    }

    public VkFramebufferAttachmentImageInfo pNext(@NativeType(value="void const *") long value) {
        VkFramebufferAttachmentImageInfo.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo flags(@NativeType(value="VkImageCreateFlags") int value) {
        VkFramebufferAttachmentImageInfo.nflags(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkFramebufferAttachmentImageInfo.nusage(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo width(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfo.nwidth(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo height(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfo.nheight(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo layerCount(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfo.nlayerCount(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkFramebufferAttachmentImageInfo.npViewFormats(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfo set(int sType, long pNext, int flags, int usage, int width, int height, int layerCount, @Nullable IntBuffer pViewFormats) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.usage(usage);
        this.width(width);
        this.height(height);
        this.layerCount(layerCount);
        this.pViewFormats(pViewFormats);
        return this;
    }

    public VkFramebufferAttachmentImageInfo set(VkFramebufferAttachmentImageInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFramebufferAttachmentImageInfo malloc() {
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfo calloc() {
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkFramebufferAttachmentImageInfo create(long address) {
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, address);
    }

    @Nullable
    public static VkFramebufferAttachmentImageInfo createSafe(long address) {
        return address == 0L ? null : VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkFramebufferAttachmentImageInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFramebufferAttachmentImageInfo.__create(capacity, SIZEOF);
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkFramebufferAttachmentImageInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkFramebufferAttachmentImageInfo malloc(MemoryStack stack) {
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfo calloc(MemoryStack stack) {
        return VkFramebufferAttachmentImageInfo.wrap(VkFramebufferAttachmentImageInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkFramebufferAttachmentImageInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static int nviewFormatCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWFORMATCOUNT);
    }

    @Nullable
    public static IntBuffer npViewFormats(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PVIEWFORMATS), VkFramebufferAttachmentImageInfo.nviewFormatCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    public static void nviewFormatCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWFORMATCOUNT, value);
    }

    public static void npViewFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWFORMATS, MemoryUtil.memAddressSafe(value));
        VkFramebufferAttachmentImageInfo.nviewFormatCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkFramebufferAttachmentImageInfo.nviewFormatCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIEWFORMATS));
        }
    }

    static {
        Struct.Layout layout = VkFramebufferAttachmentImageInfo.__struct(VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(POINTER_SIZE), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(4), VkFramebufferAttachmentImageInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        USAGE = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
        LAYERCOUNT = layout.offsetof(6);
        VIEWFORMATCOUNT = layout.offsetof(7);
        PVIEWFORMATS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkFramebufferAttachmentImageInfo, Buffer>
    implements NativeResource {
        private static final VkFramebufferAttachmentImageInfo ELEMENT_FACTORY = VkFramebufferAttachmentImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkFramebufferAttachmentImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFramebufferAttachmentImageInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFramebufferAttachmentImageInfo.npNext(this.address());
        }

        @NativeType(value="VkImageCreateFlags")
        public int flags() {
            return VkFramebufferAttachmentImageInfo.nflags(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int usage() {
            return VkFramebufferAttachmentImageInfo.nusage(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkFramebufferAttachmentImageInfo.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkFramebufferAttachmentImageInfo.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkFramebufferAttachmentImageInfo.nlayerCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewFormatCount() {
            return VkFramebufferAttachmentImageInfo.nviewFormatCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pViewFormats() {
            return VkFramebufferAttachmentImageInfo.npViewFormats(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFramebufferAttachmentImageInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000108002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFramebufferAttachmentImageInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkImageCreateFlags") int value) {
            VkFramebufferAttachmentImageInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkFramebufferAttachmentImageInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfo.nlayerCount(this.address(), value);
            return this;
        }

        public Buffer pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkFramebufferAttachmentImageInfo.npViewFormats(this.address(), value);
            return this;
        }
    }
}

