/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExportFenceCreateInfo;
import org.lwjgl.vulkan.VkExportFenceCreateInfoKHR;
import org.lwjgl.vulkan.VkExportFenceWin32HandleInfoKHR;

public class VkFenceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    public VkFenceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFenceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFenceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFenceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkFenceCreateFlags")
    public int flags() {
        return VkFenceCreateInfo.nflags(this.address());
    }

    public VkFenceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFenceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo sType$Default() {
        return this.sType(8);
    }

    public VkFenceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkFenceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo pNext(VkExportFenceCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo pNext(VkExportFenceCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo pNext(VkExportFenceWin32HandleInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo flags(@NativeType(value="VkFenceCreateFlags") int value) {
        VkFenceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkFenceCreateInfo set(VkFenceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFenceCreateInfo malloc() {
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkFenceCreateInfo calloc() {
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkFenceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkFenceCreateInfo create(long address) {
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, address);
    }

    @Nullable
    public static VkFenceCreateInfo createSafe(long address) {
        return address == 0L ? null : VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkFenceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkFenceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkFenceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFenceCreateInfo.__create(capacity, SIZEOF);
        return VkFenceCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkFenceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkFenceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkFenceCreateInfo mallocStack() {
        return VkFenceCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFenceCreateInfo callocStack() {
        return VkFenceCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFenceCreateInfo mallocStack(MemoryStack stack) {
        return VkFenceCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkFenceCreateInfo callocStack(MemoryStack stack) {
        return VkFenceCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkFenceCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkFenceCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.calloc(capacity, stack);
    }

    public static VkFenceCreateInfo malloc(MemoryStack stack) {
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFenceCreateInfo calloc(MemoryStack stack) {
        return VkFenceCreateInfo.wrap(VkFenceCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkFenceCreateInfo.__struct(VkFenceCreateInfo.__member(4), VkFenceCreateInfo.__member(POINTER_SIZE), VkFenceCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFenceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkFenceCreateInfo ELEMENT_FACTORY = VkFenceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkFenceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFenceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFenceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkFenceCreateFlags")
        public int flags() {
            return VkFenceCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFenceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(8);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFenceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportFenceCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportFenceCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportFenceWin32HandleInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkFenceCreateFlags") int value) {
            VkFenceCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

