/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryImageCreateInfo;

public class VkExternalMemoryImageCreateInfoKHR
extends VkExternalMemoryImageCreateInfo {
    public VkExternalMemoryImageCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR sType$Default() {
        return this.sType(1000072001);
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryImageCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfoKHR set(VkExternalMemoryImageCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfoKHR malloc() {
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR calloc() {
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExternalMemoryImageCreateInfoKHR create(long address) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkExternalMemoryImageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExternalMemoryImageCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryImageCreateInfoKHR.__create(capacity, SIZEOF);
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoKHR mallocStack() {
        return VkExternalMemoryImageCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoKHR callocStack() {
        return VkExternalMemoryImageCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkExternalMemoryImageCreateInfoKHR malloc(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryImageCreateInfoKHR calloc(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(VkExternalMemoryImageCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExternalMemoryImageCreateInfo.Buffer {
        private static final VkExternalMemoryImageCreateInfoKHR ELEMENT_FACTORY = VkExternalMemoryImageCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalMemoryImageCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000072001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryImageCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

