/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    public VkExternalMemoryBufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalMemoryBufferCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo sType$Default() {
        return this.sType(1000072000);
    }

    public VkExternalMemoryBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfo set(VkExternalMemoryBufferCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfo malloc() {
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo calloc() {
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExternalMemoryBufferCreateInfo create(long address) {
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, address);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExternalMemoryBufferCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryBufferCreateInfo.__create(capacity, SIZEOF);
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo mallocStack() {
        return VkExternalMemoryBufferCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo callocStack() {
        return VkExternalMemoryBufferCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfo callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.calloc(capacity, stack);
    }

    public static VkExternalMemoryBufferCreateInfo malloc(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfo calloc(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.wrap(VkExternalMemoryBufferCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryBufferCreateInfo.__struct(VkExternalMemoryBufferCreateInfo.__member(4), VkExternalMemoryBufferCreateInfo.__member(POINTER_SIZE), VkExternalMemoryBufferCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryBufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkExternalMemoryBufferCreateInfo ELEMENT_FACTORY = VkExternalMemoryBufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalMemoryBufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000072000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

