/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDevicePrivateDataCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRIVATEDATASLOTREQUESTCOUNT;

    public VkDevicePrivateDataCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDevicePrivateDataCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDevicePrivateDataCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDevicePrivateDataCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int privateDataSlotRequestCount() {
        return VkDevicePrivateDataCreateInfo.nprivateDataSlotRequestCount(this.address());
    }

    public VkDevicePrivateDataCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDevicePrivateDataCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDevicePrivateDataCreateInfo sType$Default() {
        return this.sType(1000295001);
    }

    public VkDevicePrivateDataCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDevicePrivateDataCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDevicePrivateDataCreateInfo privateDataSlotRequestCount(@NativeType(value="uint32_t") int value) {
        VkDevicePrivateDataCreateInfo.nprivateDataSlotRequestCount(this.address(), value);
        return this;
    }

    public VkDevicePrivateDataCreateInfo set(int sType, long pNext, int privateDataSlotRequestCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.privateDataSlotRequestCount(privateDataSlotRequestCount);
        return this;
    }

    public VkDevicePrivateDataCreateInfo set(VkDevicePrivateDataCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDevicePrivateDataCreateInfo malloc() {
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfo calloc() {
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDevicePrivateDataCreateInfo create(long address) {
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, address);
    }

    @Nullable
    public static VkDevicePrivateDataCreateInfo createSafe(long address) {
        return address == 0L ? null : VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDevicePrivateDataCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDevicePrivateDataCreateInfo.__create(capacity, SIZEOF);
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDevicePrivateDataCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkDevicePrivateDataCreateInfo malloc(MemoryStack stack) {
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfo calloc(MemoryStack stack) {
        return VkDevicePrivateDataCreateInfo.wrap(VkDevicePrivateDataCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDevicePrivateDataCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprivateDataSlotRequestCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIVATEDATASLOTREQUESTCOUNT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprivateDataSlotRequestCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIVATEDATASLOTREQUESTCOUNT, value);
    }

    static {
        Struct.Layout layout = VkDevicePrivateDataCreateInfo.__struct(VkDevicePrivateDataCreateInfo.__member(4), VkDevicePrivateDataCreateInfo.__member(POINTER_SIZE), VkDevicePrivateDataCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRIVATEDATASLOTREQUESTCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDevicePrivateDataCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDevicePrivateDataCreateInfo ELEMENT_FACTORY = VkDevicePrivateDataCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDevicePrivateDataCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDevicePrivateDataCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDevicePrivateDataCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int privateDataSlotRequestCount() {
            return VkDevicePrivateDataCreateInfo.nprivateDataSlotRequestCount(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDevicePrivateDataCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000295001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDevicePrivateDataCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer privateDataSlotRequestCount(@NativeType(value="uint32_t") int value) {
            VkDevicePrivateDataCreateInfo.nprivateDataSlotRequestCount(this.address(), value);
            return this;
        }
    }
}

