/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetLayoutBinding
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BINDING;
    public static final int DESCRIPTORTYPE;
    public static final int DESCRIPTORCOUNT;
    public static final int STAGEFLAGS;
    public static final int PIMMUTABLESAMPLERS;

    public VkDescriptorSetLayoutBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorSetLayoutBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return VkDescriptorSetLayoutBinding.nbinding(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkDescriptorSetLayoutBinding.ndescriptorType(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorSetLayoutBinding.ndescriptorCount(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkDescriptorSetLayoutBinding.nstageFlags(this.address());
    }

    @Nullable
    @NativeType(value="VkSampler const *")
    public LongBuffer pImmutableSamplers() {
        return VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address());
    }

    public VkDescriptorSetLayoutBinding binding(@NativeType(value="uint32_t") int value) {
        VkDescriptorSetLayoutBinding.nbinding(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorSetLayoutBinding.ndescriptorType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorSetLayoutBinding.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkDescriptorSetLayoutBinding.nstageFlags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding pImmutableSamplers(@Nullable @NativeType(value="VkSampler const *") LongBuffer value) {
        VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutBinding set(int binding, int descriptorType, int descriptorCount, int stageFlags, @Nullable LongBuffer pImmutableSamplers) {
        this.binding(binding);
        this.descriptorType(descriptorType);
        this.descriptorCount(descriptorCount);
        this.stageFlags(stageFlags);
        this.pImmutableSamplers(pImmutableSamplers);
        return this;
    }

    public VkDescriptorSetLayoutBinding set(VkDescriptorSetLayoutBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutBinding malloc() {
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding calloc() {
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorSetLayoutBinding create(long address) {
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, address);
    }

    @Nullable
    public static VkDescriptorSetLayoutBinding createSafe(long address) {
        return address == 0L ? null : VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDescriptorSetLayoutBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetLayoutBinding.__create(capacity, SIZEOF);
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDescriptorSetLayoutBinding.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDescriptorSetLayoutBinding mallocStack() {
        return VkDescriptorSetLayoutBinding.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutBinding callocStack() {
        return VkDescriptorSetLayoutBinding.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutBinding mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorSetLayoutBinding callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutBinding.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutBinding.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.calloc(capacity, stack);
    }

    public static VkDescriptorSetLayoutBinding malloc(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutBinding calloc(MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.wrap(VkDescriptorSetLayoutBinding.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutBinding.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int ndescriptorType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORTYPE);
    }

    public static int ndescriptorCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORCOUNT);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    @Nullable
    public static LongBuffer npImmutableSamplers(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PIMMUTABLESAMPLERS), VkDescriptorSetLayoutBinding.ndescriptorCount(struct));
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void ndescriptorType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORTYPE, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void npImmutableSamplers(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMMUTABLESAMPLERS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkDescriptorSetLayoutBinding.ndescriptorCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutBinding.__struct(VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(4), VkDescriptorSetLayoutBinding.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BINDING = layout.offsetof(0);
        DESCRIPTORTYPE = layout.offsetof(1);
        DESCRIPTORCOUNT = layout.offsetof(2);
        STAGEFLAGS = layout.offsetof(3);
        PIMMUTABLESAMPLERS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutBinding, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetLayoutBinding ELEMENT_FACTORY = VkDescriptorSetLayoutBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDescriptorSetLayoutBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return VkDescriptorSetLayoutBinding.nbinding(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkDescriptorSetLayoutBinding.ndescriptorType(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorSetLayoutBinding.ndescriptorCount(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkDescriptorSetLayoutBinding.nstageFlags(this.address());
        }

        @Nullable
        @NativeType(value="VkSampler const *")
        public LongBuffer pImmutableSamplers() {
            return VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address());
        }

        public Buffer binding(@NativeType(value="uint32_t") int value) {
            VkDescriptorSetLayoutBinding.nbinding(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorSetLayoutBinding.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorSetLayoutBinding.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkDescriptorSetLayoutBinding.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer pImmutableSamplers(@Nullable @NativeType(value="VkSampler const *") LongBuffer value) {
            VkDescriptorSetLayoutBinding.npImmutableSamplers(this.address(), value);
            return this;
        }
    }
}

