/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerMarkerInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PMARKERNAME;
    public static final int COLOR;

    public VkDebugMarkerMarkerInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDebugMarkerMarkerInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pMarkerName() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
    }

    @NativeType(value="char const *")
    public String pMarkerNameString() {
        return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer color() {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
    }

    public float color(int index) {
        return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
    }

    public VkDebugMarkerMarkerInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT sType$Default() {
        return this.sType(1000022002);
    }

    public VkDebugMarkerMarkerInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT pMarkerName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(@NativeType(value="float[4]") FloatBuffer value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT color(int index, float value) {
        VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(int sType, long pNext, ByteBuffer pMarkerName, FloatBuffer color) {
        this.sType(sType);
        this.pNext(pNext);
        this.pMarkerName(pMarkerName);
        this.color(color);
        return this;
    }

    public VkDebugMarkerMarkerInfoEXT set(VkDebugMarkerMarkerInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugMarkerMarkerInfoEXT malloc() {
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT calloc() {
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDebugMarkerMarkerInfoEXT create(long address) {
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, address);
    }

    @Nullable
    public static VkDebugMarkerMarkerInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDebugMarkerMarkerInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugMarkerMarkerInfoEXT.__create(capacity, SIZEOF);
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDebugMarkerMarkerInfoEXT mallocStack() {
        return VkDebugMarkerMarkerInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerMarkerInfoEXT callocStack() {
        return VkDebugMarkerMarkerInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerMarkerInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugMarkerMarkerInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerMarkerInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugMarkerMarkerInfoEXT malloc(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerMarkerInfoEXT calloc(MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.wrap(VkDebugMarkerMarkerInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDebugMarkerMarkerInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npMarkerName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static String npMarkerNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    public static FloatBuffer ncolor(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)COLOR, 4);
    }

    public static float ncolor(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)COLOR + Checks.check(index, 4) * 4L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npMarkerName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PMARKERNAME, MemoryUtil.memAddress(value));
    }

    public static void ncolor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLOR, value.remaining() * 4);
    }

    public static void ncolor(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)COLOR + Checks.check(index, 4) * 4L, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PMARKERNAME));
    }

    static {
        Struct.Layout layout = VkDebugMarkerMarkerInfoEXT.__struct(VkDebugMarkerMarkerInfoEXT.__member(4), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__member(POINTER_SIZE), VkDebugMarkerMarkerInfoEXT.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PMARKERNAME = layout.offsetof(2);
        COLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerMarkerInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugMarkerMarkerInfoEXT ELEMENT_FACTORY = VkDebugMarkerMarkerInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDebugMarkerMarkerInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerMarkerInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerMarkerInfoEXT.npNext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pMarkerName() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address());
        }

        @NativeType(value="char const *")
        public String pMarkerNameString() {
            return VkDebugMarkerMarkerInfoEXT.npMarkerNameString(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer color() {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address());
        }

        public float color(int index) {
            return VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerMarkerInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000022002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerMarkerInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pMarkerName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugMarkerMarkerInfoEXT.npMarkerName(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="float[4]") FloatBuffer value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(int index, float value) {
            VkDebugMarkerMarkerInfoEXT.ncolor(this.address(), index, value);
            return this;
        }
    }
}

