/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkClearRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    public VkClearRect(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkClearRect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkRect2D rect() {
        return VkClearRect.nrect(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkClearRect.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkClearRect.nlayerCount(this.address());
    }

    public VkClearRect rect(VkRect2D value) {
        VkClearRect.nrect(this.address(), value);
        return this;
    }

    public VkClearRect rect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.rect());
        return this;
    }

    public VkClearRect baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkClearRect.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkClearRect layerCount(@NativeType(value="uint32_t") int value) {
        VkClearRect.nlayerCount(this.address(), value);
        return this;
    }

    public VkClearRect set(VkRect2D rect, int baseArrayLayer, int layerCount) {
        this.rect(rect);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkClearRect set(VkClearRect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearRect malloc() {
        return VkClearRect.wrap(VkClearRect.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkClearRect calloc() {
        return VkClearRect.wrap(VkClearRect.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkClearRect create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkClearRect.wrap(VkClearRect.class, MemoryUtil.memAddress(container), container);
    }

    public static VkClearRect create(long address) {
        return VkClearRect.wrap(VkClearRect.class, address);
    }

    @Nullable
    public static VkClearRect createSafe(long address) {
        return address == 0L ? null : VkClearRect.wrap(VkClearRect.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkClearRect.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkClearRect.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearRect.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearRect.__create(capacity, SIZEOF);
        return VkClearRect.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkClearRect.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkClearRect.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkClearRect mallocStack() {
        return VkClearRect.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearRect callocStack() {
        return VkClearRect.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearRect mallocStack(MemoryStack stack) {
        return VkClearRect.malloc(stack);
    }

    @Deprecated
    public static VkClearRect callocStack(MemoryStack stack) {
        return VkClearRect.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearRect.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearRect.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearRect.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearRect.calloc(capacity, stack);
    }

    public static VkClearRect malloc(MemoryStack stack) {
        return VkClearRect.wrap(VkClearRect.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearRect calloc(MemoryStack stack) {
        return VkClearRect.wrap(VkClearRect.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkClearRect.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkClearRect.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkRect2D nrect(long struct) {
        return VkRect2D.create(struct + (long)RECT);
    }

    public static int nbaseArrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static void nrect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RECT, VkRect2D.SIZEOF);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkClearRect.__struct(VkClearRect.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkClearRect.__member(4), VkClearRect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECT = layout.offsetof(0);
        BASEARRAYLAYER = layout.offsetof(1);
        LAYERCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearRect, Buffer>
    implements NativeResource {
        private static final VkClearRect ELEMENT_FACTORY = VkClearRect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkClearRect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkRect2D rect() {
            return VkClearRect.nrect(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkClearRect.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkClearRect.nlayerCount(this.address());
        }

        public Buffer rect(VkRect2D value) {
            VkClearRect.nrect(this.address(), value);
            return this;
        }

        public Buffer rect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.rect());
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkClearRect.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkClearRect.nlayerCount(this.address(), value);
            return this;
        }
    }
}

