/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferViewCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BUFFER;
    public static final int FORMAT;
    public static final int OFFSET;
    public static final int RANGE;

    public VkBufferViewCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferViewCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferViewCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferViewCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkBufferViewCreateFlags")
    public int flags() {
        return VkBufferViewCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferViewCreateInfo.nbuffer(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkBufferViewCreateInfo.nformat(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkBufferViewCreateInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long range() {
        return VkBufferViewCreateInfo.nrange(this.address());
    }

    public VkBufferViewCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferViewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo sType$Default() {
        return this.sType(13);
    }

    public VkBufferViewCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferViewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo flags(@NativeType(value="VkBufferViewCreateFlags") int value) {
        VkBufferViewCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferViewCreateInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo format(@NativeType(value="VkFormat") int value) {
        VkBufferViewCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferViewCreateInfo.noffset(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo range(@NativeType(value="VkDeviceSize") long value) {
        VkBufferViewCreateInfo.nrange(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo set(int sType, long pNext, int flags, long buffer, int format, long offset, long range) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.buffer(buffer);
        this.format(format);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkBufferViewCreateInfo set(VkBufferViewCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferViewCreateInfo malloc() {
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferViewCreateInfo calloc() {
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferViewCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferViewCreateInfo create(long address) {
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, address);
    }

    @Nullable
    public static VkBufferViewCreateInfo createSafe(long address) {
        return address == 0L ? null : VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferViewCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferViewCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferViewCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferViewCreateInfo.__create(capacity, SIZEOF);
        return VkBufferViewCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferViewCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferViewCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBufferViewCreateInfo mallocStack() {
        return VkBufferViewCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferViewCreateInfo callocStack() {
        return VkBufferViewCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferViewCreateInfo mallocStack(MemoryStack stack) {
        return VkBufferViewCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkBufferViewCreateInfo callocStack(MemoryStack stack) {
        return VkBufferViewCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferViewCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferViewCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.calloc(capacity, stack);
    }

    public static VkBufferViewCreateInfo malloc(MemoryStack stack) {
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferViewCreateInfo calloc(MemoryStack stack) {
        return VkBufferViewCreateInfo.wrap(VkBufferViewCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return UNSAFE.getLong(null, struct + (long)RANGE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkBufferViewCreateInfo.__struct(VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(POINTER_SIZE), VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(8), VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(8), VkBufferViewCreateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        OFFSET = layout.offsetof(5);
        RANGE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkBufferViewCreateInfo, Buffer>
    implements NativeResource {
        private static final VkBufferViewCreateInfo ELEMENT_FACTORY = VkBufferViewCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferViewCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferViewCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferViewCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkBufferViewCreateFlags")
        public int flags() {
            return VkBufferViewCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferViewCreateInfo.nbuffer(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkBufferViewCreateInfo.nformat(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkBufferViewCreateInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long range() {
            return VkBufferViewCreateInfo.nrange(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferViewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(13);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferViewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBufferViewCreateFlags") int value) {
            VkBufferViewCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferViewCreateInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkBufferViewCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferViewCreateInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="VkDeviceSize") long value) {
            VkBufferViewCreateInfo.nrange(this.address(), value);
            return this;
        }
    }
}

