/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferImageCopy2;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkBufferImageCopy2KHR
extends VkBufferImageCopy2 {
    public VkBufferImageCopy2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferImageCopy2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferImageCopy2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR sType$Default() {
        return this.sType(1000337009);
    }

    @Override
    public VkBufferImageCopy2KHR pNext(@NativeType(value="void const *") long value) {
        VkBufferImageCopy2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR bufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferImageCopy2KHR.nbufferOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR bufferRowLength(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy2KHR.nbufferRowLength(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR bufferImageHeight(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy2KHR.nbufferImageHeight(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageSubresource(VkImageSubresourceLayers value) {
        VkBufferImageCopy2KHR.nimageSubresource(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageOffset(VkOffset3D value) {
        VkBufferImageCopy2KHR.nimageOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageExtent(VkExtent3D value) {
        VkBufferImageCopy2KHR.nimageExtent(this.address(), value);
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    @Override
    public VkBufferImageCopy2KHR set(int sType, long pNext, long bufferOffset, int bufferRowLength, int bufferImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.bufferOffset(bufferOffset);
        this.bufferRowLength(bufferRowLength);
        this.bufferImageHeight(bufferImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkBufferImageCopy2KHR set(VkBufferImageCopy2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferImageCopy2KHR malloc() {
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferImageCopy2KHR calloc() {
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferImageCopy2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferImageCopy2KHR create(long address) {
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, address);
    }

    @Nullable
    public static VkBufferImageCopy2KHR createSafe(long address) {
        return address == 0L ? null : VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferImageCopy2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferImageCopy2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferImageCopy2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferImageCopy2KHR.__create(capacity, SIZEOF);
        return VkBufferImageCopy2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferImageCopy2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferImageCopy2KHR.wrap(Buffer.class, address, capacity);
    }

    public static VkBufferImageCopy2KHR malloc(MemoryStack stack) {
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferImageCopy2KHR calloc(MemoryStack stack) {
        return VkBufferImageCopy2KHR.wrap(VkBufferImageCopy2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferImageCopy2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferImageCopy2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferImageCopy2.Buffer {
        private static final VkBufferImageCopy2KHR ELEMENT_FACTORY = VkBufferImageCopy2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferImageCopy2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferImageCopy2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000337009);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferImageCopy2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer bufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferImageCopy2KHR.nbufferOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer bufferRowLength(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy2KHR.nbufferRowLength(this.address(), value);
            return this;
        }

        @Override
        public Buffer bufferImageHeight(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy2KHR.nbufferImageHeight(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkBufferImageCopy2KHR.nimageSubresource(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        @Override
        public Buffer imageOffset(VkOffset3D value) {
            VkBufferImageCopy2KHR.nimageOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        @Override
        public Buffer imageExtent(VkExtent3D value) {
            VkBufferImageCopy2KHR.nimageExtent(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

