/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferDeviceAddressInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;

    public VkBufferDeviceAddressInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferDeviceAddressInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferDeviceAddressInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferDeviceAddressInfo.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferDeviceAddressInfo.nbuffer(this.address());
    }

    public VkBufferDeviceAddressInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo sType$Default() {
        return this.sType(1000244001);
    }

    public VkBufferDeviceAddressInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfo set(VkBufferDeviceAddressInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfo malloc() {
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferDeviceAddressInfo calloc() {
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferDeviceAddressInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferDeviceAddressInfo create(long address) {
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, address);
    }

    @Nullable
    public static VkBufferDeviceAddressInfo createSafe(long address) {
        return address == 0L ? null : VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferDeviceAddressInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfo.__create(capacity, SIZEOF);
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferDeviceAddressInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkBufferDeviceAddressInfo malloc(MemoryStack stack) {
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferDeviceAddressInfo calloc(MemoryStack stack) {
        return VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkBufferDeviceAddressInfo.__struct(VkBufferDeviceAddressInfo.__member(4), VkBufferDeviceAddressInfo.__member(POINTER_SIZE), VkBufferDeviceAddressInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferDeviceAddressInfo, Buffer>
    implements NativeResource {
        private static final VkBufferDeviceAddressInfo ELEMENT_FACTORY = VkBufferDeviceAddressInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferDeviceAddressInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferDeviceAddressInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferDeviceAddressInfo.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferDeviceAddressInfo.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000244001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfo.nbuffer(this.address(), value);
            return this;
        }
    }
}

