/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfo;

public class VkBindImagePlaneMemoryInfoKHR
extends VkBindImagePlaneMemoryInfo {
    public VkBindImagePlaneMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType$Default() {
        return this.sType(1000156002);
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfoKHR set(VkBindImagePlaneMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc() {
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc() {
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBindImagePlaneMemoryInfoKHR create(long address) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, address);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBindImagePlaneMemoryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImagePlaneMemoryInfoKHR.__create(capacity, SIZEOF);
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR mallocStack() {
        return VkBindImagePlaneMemoryInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR callocStack() {
        return VkBindImagePlaneMemoryInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(capacity, stack);
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(VkBindImagePlaneMemoryInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImagePlaneMemoryInfo.Buffer {
        private static final VkBindImagePlaneMemoryInfoKHR ELEMENT_FACTORY = VkBindImagePlaneMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindImagePlaneMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000156002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

