/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSRTDataNV;

public class VkAccelerationStructureSRTMotionInstanceNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRANSFORMT0;
    public static final int TRANSFORMT1;
    public static final int BITFIELD0;
    public static final int BITFIELD1;
    public static final int ACCELERATIONSTRUCTUREREFERENCE;

    public VkAccelerationStructureSRTMotionInstanceNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureSRTMotionInstanceNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkSRTDataNV transformT0() {
        return VkAccelerationStructureSRTMotionInstanceNV.ntransformT0(this.address());
    }

    public VkSRTDataNV transformT1() {
        return VkAccelerationStructureSRTMotionInstanceNV.ntransformT1(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCustomIndex() {
        return VkAccelerationStructureSRTMotionInstanceNV.ninstanceCustomIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int mask() {
        return VkAccelerationStructureSRTMotionInstanceNV.nmask(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceShaderBindingTableRecordOffset() {
        return VkAccelerationStructureSRTMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address());
    }

    @NativeType(value="VkGeometryInstanceFlagsKHR")
    public int flags() {
        return VkAccelerationStructureSRTMotionInstanceNV.nflags(this.address());
    }

    @NativeType(value="uint64_t")
    public long accelerationStructureReference() {
        return VkAccelerationStructureSRTMotionInstanceNV.naccelerationStructureReference(this.address());
    }

    public VkAccelerationStructureSRTMotionInstanceNV transformT0(VkSRTDataNV value) {
        VkAccelerationStructureSRTMotionInstanceNV.ntransformT0(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV transformT0(Consumer<VkSRTDataNV> consumer) {
        consumer.accept(this.transformT0());
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV transformT1(VkSRTDataNV value) {
        VkAccelerationStructureSRTMotionInstanceNV.ntransformT1(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV transformT1(Consumer<VkSRTDataNV> consumer) {
        consumer.accept(this.transformT1());
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV instanceCustomIndex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureSRTMotionInstanceNV.ninstanceCustomIndex(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV mask(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nmask(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureSRTMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV accelerationStructureReference(@NativeType(value="uint64_t") long value) {
        VkAccelerationStructureSRTMotionInstanceNV.naccelerationStructureReference(this.address(), value);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV set(VkSRTDataNV transformT0, VkSRTDataNV transformT1, int instanceCustomIndex, int mask, int instanceShaderBindingTableRecordOffset, int flags, long accelerationStructureReference) {
        this.transformT0(transformT0);
        this.transformT1(transformT1);
        this.instanceCustomIndex(instanceCustomIndex);
        this.mask(mask);
        this.instanceShaderBindingTableRecordOffset(instanceShaderBindingTableRecordOffset);
        this.flags(flags);
        this.accelerationStructureReference(accelerationStructureReference);
        return this;
    }

    public VkAccelerationStructureSRTMotionInstanceNV set(VkAccelerationStructureSRTMotionInstanceNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureSRTMotionInstanceNV malloc() {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureSRTMotionInstanceNV calloc() {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureSRTMotionInstanceNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureSRTMotionInstanceNV create(long address) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, address);
    }

    @Nullable
    public static VkAccelerationStructureSRTMotionInstanceNV createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureSRTMotionInstanceNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureSRTMotionInstanceNV.__create(capacity, SIZEOF);
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureSRTMotionInstanceNV malloc(MemoryStack stack) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureSRTMotionInstanceNV calloc(MemoryStack stack) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(VkAccelerationStructureSRTMotionInstanceNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureSRTMotionInstanceNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkSRTDataNV ntransformT0(long struct) {
        return VkSRTDataNV.create(struct + (long)TRANSFORMT0);
    }

    public static VkSRTDataNV ntransformT1(long struct) {
        return VkSRTDataNV.create(struct + (long)TRANSFORMT1);
    }

    public static int nbitfield0(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD0);
    }

    public static int ninstanceCustomIndex(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct) & 0xFFFFFF;
    }

    public static int nmask(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct) >>> 24;
    }

    public static int nbitfield1(long struct) {
        return UNSAFE.getInt(null, struct + (long)BITFIELD1);
    }

    public static int ninstanceShaderBindingTableRecordOffset(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct) & 0xFFFFFF;
    }

    public static int nflags(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct) >>> 24;
    }

    public static long naccelerationStructureReference(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE);
    }

    public static void ntransformT0(long struct, VkSRTDataNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSFORMT0, VkSRTDataNV.SIZEOF);
    }

    public static void ntransformT1(long struct, VkSRTDataNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSFORMT1, VkSRTDataNV.SIZEOF);
    }

    public static void nbitfield0(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD0, value);
    }

    public static void ninstanceCustomIndex(long struct, int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct, VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nmask(long struct, int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct, value << 24 | VkAccelerationStructureSRTMotionInstanceNV.nbitfield0(struct) & 0xFFFFFF);
    }

    public static void nbitfield1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BITFIELD1, value);
    }

    public static void ninstanceShaderBindingTableRecordOffset(long struct, int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct, VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct) & 0xFF000000 | value & 0xFFFFFF);
    }

    public static void nflags(long struct, int value) {
        VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct, value << 24 | VkAccelerationStructureSRTMotionInstanceNV.nbitfield1(struct) & 0xFFFFFF);
    }

    public static void naccelerationStructureReference(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ACCELERATIONSTRUCTUREREFERENCE, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureSRTMotionInstanceNV.__struct(VkAccelerationStructureSRTMotionInstanceNV.__member(VkSRTDataNV.SIZEOF, VkSRTDataNV.ALIGNOF), VkAccelerationStructureSRTMotionInstanceNV.__member(VkSRTDataNV.SIZEOF, VkSRTDataNV.ALIGNOF), VkAccelerationStructureSRTMotionInstanceNV.__member(4), VkAccelerationStructureSRTMotionInstanceNV.__member(4), VkAccelerationStructureSRTMotionInstanceNV.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRANSFORMT0 = layout.offsetof(0);
        TRANSFORMT1 = layout.offsetof(1);
        BITFIELD0 = layout.offsetof(2);
        BITFIELD1 = layout.offsetof(3);
        ACCELERATIONSTRUCTUREREFERENCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureSRTMotionInstanceNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureSRTMotionInstanceNV ELEMENT_FACTORY = VkAccelerationStructureSRTMotionInstanceNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureSRTMotionInstanceNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkSRTDataNV transformT0() {
            return VkAccelerationStructureSRTMotionInstanceNV.ntransformT0(this.address());
        }

        public VkSRTDataNV transformT1() {
            return VkAccelerationStructureSRTMotionInstanceNV.ntransformT1(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCustomIndex() {
            return VkAccelerationStructureSRTMotionInstanceNV.ninstanceCustomIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int mask() {
            return VkAccelerationStructureSRTMotionInstanceNV.nmask(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceShaderBindingTableRecordOffset() {
            return VkAccelerationStructureSRTMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address());
        }

        @NativeType(value="VkGeometryInstanceFlagsKHR")
        public int flags() {
            return VkAccelerationStructureSRTMotionInstanceNV.nflags(this.address());
        }

        @NativeType(value="uint64_t")
        public long accelerationStructureReference() {
            return VkAccelerationStructureSRTMotionInstanceNV.naccelerationStructureReference(this.address());
        }

        public Buffer transformT0(VkSRTDataNV value) {
            VkAccelerationStructureSRTMotionInstanceNV.ntransformT0(this.address(), value);
            return this;
        }

        public Buffer transformT0(Consumer<VkSRTDataNV> consumer) {
            consumer.accept(this.transformT0());
            return this;
        }

        public Buffer transformT1(VkSRTDataNV value) {
            VkAccelerationStructureSRTMotionInstanceNV.ntransformT1(this.address(), value);
            return this;
        }

        public Buffer transformT1(Consumer<VkSRTDataNV> consumer) {
            consumer.accept(this.transformT1());
            return this;
        }

        public Buffer instanceCustomIndex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureSRTMotionInstanceNV.ninstanceCustomIndex(this.address(), value);
            return this;
        }

        public Buffer mask(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureSRTMotionInstanceNV.nmask(this.address(), value);
            return this;
        }

        public Buffer instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureSRTMotionInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
            VkAccelerationStructureSRTMotionInstanceNV.nflags(this.address(), value);
            return this;
        }

        public Buffer accelerationStructureReference(@NativeType(value="uint64_t") long value) {
            VkAccelerationStructureSRTMotionInstanceNV.naccelerationStructureReference(this.address(), value);
            return this;
        }
    }
}

