/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAccelerationStructureMotionInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MAXINSTANCES;
    public static final int FLAGS;

    public VkAccelerationStructureMotionInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureMotionInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureMotionInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureMotionInfoNV.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxInstances() {
        return VkAccelerationStructureMotionInfoNV.nmaxInstances(this.address());
    }

    @NativeType(value="VkAccelerationStructureMotionInfoFlagsNV")
    public int flags() {
        return VkAccelerationStructureMotionInfoNV.nflags(this.address());
    }

    public VkAccelerationStructureMotionInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureMotionInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInfoNV sType$Default() {
        return this.sType(1000327002);
    }

    public VkAccelerationStructureMotionInfoNV pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureMotionInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInfoNV maxInstances(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureMotionInfoNV.nmaxInstances(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInfoNV flags(@NativeType(value="VkAccelerationStructureMotionInfoFlagsNV") int value) {
        VkAccelerationStructureMotionInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInfoNV set(int sType, long pNext, int maxInstances, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.maxInstances(maxInstances);
        this.flags(flags);
        return this;
    }

    public VkAccelerationStructureMotionInfoNV set(VkAccelerationStructureMotionInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureMotionInfoNV malloc() {
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureMotionInfoNV calloc() {
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureMotionInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureMotionInfoNV create(long address) {
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, address);
    }

    @Nullable
    public static VkAccelerationStructureMotionInfoNV createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureMotionInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureMotionInfoNV.__create(capacity, SIZEOF);
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureMotionInfoNV malloc(MemoryStack stack) {
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureMotionInfoNV calloc(MemoryStack stack) {
        return VkAccelerationStructureMotionInfoNV.wrap(VkAccelerationStructureMotionInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureMotionInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmaxInstances(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXINSTANCES);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmaxInstances(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXINSTANCES, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureMotionInfoNV.__struct(VkAccelerationStructureMotionInfoNV.__member(4), VkAccelerationStructureMotionInfoNV.__member(POINTER_SIZE), VkAccelerationStructureMotionInfoNV.__member(4), VkAccelerationStructureMotionInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MAXINSTANCES = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureMotionInfoNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureMotionInfoNV ELEMENT_FACTORY = VkAccelerationStructureMotionInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureMotionInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureMotionInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureMotionInfoNV.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxInstances() {
            return VkAccelerationStructureMotionInfoNV.nmaxInstances(this.address());
        }

        @NativeType(value="VkAccelerationStructureMotionInfoFlagsNV")
        public int flags() {
            return VkAccelerationStructureMotionInfoNV.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureMotionInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000327002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureMotionInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer maxInstances(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureMotionInfoNV.nmaxInstances(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkAccelerationStructureMotionInfoFlagsNV") int value) {
            VkAccelerationStructureMotionInfoNV.nflags(this.address(), value);
            return this;
        }
    }
}

