/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGeometryNV;

public class VkAccelerationStructureInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int INSTANCECOUNT;
    public static final int GEOMETRYCOUNT;
    public static final int PGEOMETRIES;

    public VkAccelerationStructureInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureInfoNV.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureTypeKHR")
    public int type() {
        return VkAccelerationStructureInfoNV.ntype(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureFlagsNV")
    public int flags() {
        return VkAccelerationStructureInfoNV.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkAccelerationStructureInfoNV.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int geometryCount() {
        return VkAccelerationStructureInfoNV.ngeometryCount(this.address());
    }

    @Nullable
    @NativeType(value="VkGeometryNV const *")
    public VkGeometryNV.Buffer pGeometries() {
        return VkAccelerationStructureInfoNV.npGeometries(this.address());
    }

    public VkAccelerationStructureInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV sType$Default() {
        return this.sType(1000165012);
    }

    public VkAccelerationStructureInfoNV pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
        VkAccelerationStructureInfoNV.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV flags(@NativeType(value="VkBuildAccelerationStructureFlagsNV") int value) {
        VkAccelerationStructureInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV instanceCount(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInfoNV.ninstanceCount(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV pGeometries(@Nullable @NativeType(value="VkGeometryNV const *") VkGeometryNV.Buffer value) {
        VkAccelerationStructureInfoNV.npGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureInfoNV set(int sType, long pNext, int type, int flags, int instanceCount, @Nullable VkGeometryNV.Buffer pGeometries) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.flags(flags);
        this.instanceCount(instanceCount);
        this.pGeometries(pGeometries);
        return this;
    }

    public VkAccelerationStructureInfoNV set(VkAccelerationStructureInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureInfoNV malloc() {
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureInfoNV calloc() {
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureInfoNV create(long address) {
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, address);
    }

    @Nullable
    public static VkAccelerationStructureInfoNV createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureInfoNV.__create(capacity, SIZEOF);
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureInfoNV.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkAccelerationStructureInfoNV mallocStack() {
        return VkAccelerationStructureInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureInfoNV callocStack() {
        return VkAccelerationStructureInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAccelerationStructureInfoNV mallocStack(MemoryStack stack) {
        return VkAccelerationStructureInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkAccelerationStructureInfoNV callocStack(MemoryStack stack) {
        return VkAccelerationStructureInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAccelerationStructureInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAccelerationStructureInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAccelerationStructureInfoNV.calloc(capacity, stack);
    }

    public static VkAccelerationStructureInfoNV malloc(MemoryStack stack) {
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureInfoNV calloc(MemoryStack stack) {
        return VkAccelerationStructureInfoNV.wrap(VkAccelerationStructureInfoNV.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureInfoNV.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ninstanceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INSTANCECOUNT);
    }

    public static int ngeometryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GEOMETRYCOUNT);
    }

    @Nullable
    public static VkGeometryNV.Buffer npGeometries(long struct) {
        return VkGeometryNV.createSafe(MemoryUtil.memGetAddress(struct + (long)PGEOMETRIES), VkAccelerationStructureInfoNV.ngeometryCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ninstanceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INSTANCECOUNT, value);
    }

    public static void ngeometryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GEOMETRYCOUNT, value);
    }

    public static void npGeometries(long struct, @Nullable VkGeometryNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PGEOMETRIES, MemoryUtil.memAddressSafe(value));
        VkAccelerationStructureInfoNV.ngeometryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkAccelerationStructureInfoNV.ngeometryCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PGEOMETRIES));
        }
    }

    static {
        Struct.Layout layout = VkAccelerationStructureInfoNV.__struct(VkAccelerationStructureInfoNV.__member(4), VkAccelerationStructureInfoNV.__member(POINTER_SIZE), VkAccelerationStructureInfoNV.__member(4), VkAccelerationStructureInfoNV.__member(4), VkAccelerationStructureInfoNV.__member(4), VkAccelerationStructureInfoNV.__member(4), VkAccelerationStructureInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        INSTANCECOUNT = layout.offsetof(4);
        GEOMETRYCOUNT = layout.offsetof(5);
        PGEOMETRIES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureInfoNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureInfoNV ELEMENT_FACTORY = VkAccelerationStructureInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureInfoNV.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureTypeKHR")
        public int type() {
            return VkAccelerationStructureInfoNV.ntype(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureFlagsNV")
        public int flags() {
            return VkAccelerationStructureInfoNV.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkAccelerationStructureInfoNV.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int geometryCount() {
            return VkAccelerationStructureInfoNV.ngeometryCount(this.address());
        }

        @Nullable
        @NativeType(value="VkGeometryNV const *")
        public VkGeometryNV.Buffer pGeometries() {
            return VkAccelerationStructureInfoNV.npGeometries(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000165012);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
            VkAccelerationStructureInfoNV.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBuildAccelerationStructureFlagsNV") int value) {
            VkAccelerationStructureInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInfoNV.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer pGeometries(@Nullable @NativeType(value="VkGeometryNV const *") VkGeometryNV.Buffer value) {
            VkAccelerationStructureInfoNV.npGeometries(this.address(), value);
            return this;
        }
    }
}

