/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.jawt.JAWTDrawingSurface;
import org.lwjgl.system.jawt.JAWTRectangle;

@NativeType(value="struct JAWT_DrawingSurfaceInfo")
public class JAWTDrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLATFORMINFO;
    public static final int DS;
    public static final int BOUNDS;
    public static final int CLIPSIZE;
    public static final int CLIP;

    public JAWTDrawingSurfaceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), JAWTDrawingSurfaceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long platformInfo() {
        return JAWTDrawingSurfaceInfo.nplatformInfo(this.address());
    }

    @NativeType(value="JAWT_DrawingSurface *")
    public JAWTDrawingSurface ds() {
        return JAWTDrawingSurfaceInfo.nds(this.address());
    }

    @NativeType(value="JAWT_Rectangle")
    public JAWTRectangle bounds() {
        return JAWTDrawingSurfaceInfo.nbounds(this.address());
    }

    @NativeType(value="jint")
    public int clipSize() {
        return JAWTDrawingSurfaceInfo.nclipSize(this.address());
    }

    @NativeType(value="JAWT_Rectangle *")
    public JAWTRectangle.Buffer clip() {
        return JAWTDrawingSurfaceInfo.nclip(this.address());
    }

    public static JAWTDrawingSurfaceInfo create(long address) {
        return JAWTDrawingSurfaceInfo.wrap(JAWTDrawingSurfaceInfo.class, address);
    }

    @Nullable
    public static JAWTDrawingSurfaceInfo createSafe(long address) {
        return address == 0L ? null : JAWTDrawingSurfaceInfo.wrap(JAWTDrawingSurfaceInfo.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return JAWTDrawingSurfaceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : JAWTDrawingSurfaceInfo.wrap(Buffer.class, address, capacity);
    }

    public static long nplatformInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PLATFORMINFO);
    }

    public static JAWTDrawingSurface nds(long struct) {
        return JAWTDrawingSurface.create(MemoryUtil.memGetAddress(struct + (long)DS));
    }

    public static JAWTRectangle nbounds(long struct) {
        return JAWTRectangle.create(struct + (long)BOUNDS);
    }

    public static int nclipSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLIPSIZE);
    }

    public static JAWTRectangle.Buffer nclip(long struct) {
        return JAWTRectangle.create(MemoryUtil.memGetAddress(struct + (long)CLIP), JAWTDrawingSurfaceInfo.nclipSize(struct));
    }

    static {
        Struct.Layout layout = JAWTDrawingSurfaceInfo.__struct(JAWTDrawingSurfaceInfo.__member(POINTER_SIZE), JAWTDrawingSurfaceInfo.__member(POINTER_SIZE), JAWTDrawingSurfaceInfo.__member(JAWTRectangle.SIZEOF, JAWTRectangle.ALIGNOF), JAWTDrawingSurfaceInfo.__member(4), JAWTDrawingSurfaceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLATFORMINFO = layout.offsetof(0);
        DS = layout.offsetof(1);
        BOUNDS = layout.offsetof(2);
        CLIPSIZE = layout.offsetof(3);
        CLIP = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<JAWTDrawingSurfaceInfo, Buffer> {
        private static final JAWTDrawingSurfaceInfo ELEMENT_FACTORY = JAWTDrawingSurfaceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected JAWTDrawingSurfaceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long platformInfo() {
            return JAWTDrawingSurfaceInfo.nplatformInfo(this.address());
        }

        @NativeType(value="JAWT_DrawingSurface *")
        public JAWTDrawingSurface ds() {
            return JAWTDrawingSurfaceInfo.nds(this.address());
        }

        @NativeType(value="JAWT_Rectangle")
        public JAWTRectangle bounds() {
            return JAWTDrawingSurfaceInfo.nbounds(this.address());
        }

        @NativeType(value="jint")
        public int clipSize() {
            return JAWTDrawingSurfaceInfo.nclipSize(this.address());
        }

        @NativeType(value="JAWT_Rectangle *")
        public JAWTRectangle.Buffer clip() {
            return JAWTDrawingSurfaceInfo.nclip(this.address());
        }
    }
}

