/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.PrintWriter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.util.Utilities;
import org.geotools.util.XArray;
import org.geotools.util.logging.LoggedFormat;

public final class Element {
    private final int offset;
    public final String keyword;
    private final List<Object> list;

    Element(Element singleton) {
        this.offset = 0;
        this.keyword = null;
        this.list = new LinkedList<Object>();
        this.list.add(singleton);
    }

    Element(AbstractParser parser, String text, ParsePosition position) throws ParseException {
        int upper;
        int lower;
        int length = text.length();
        for (lower = position.getIndex(); lower < length && Character.isWhitespace(text.charAt(lower)); ++lower) {
        }
        this.offset = lower;
        for (upper = lower; upper < length && Character.isUnicodeIdentifierPart(text.charAt(upper)); ++upper) {
        }
        if (upper <= lower) {
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        this.keyword = text.substring(lower, upper).toUpperCase(parser.symbols.locale);
        position.setIndex(upper);
        int bracketIndex = -1;
        do {
            if (++bracketIndex < parser.symbols.openingBrackets.length) continue;
            this.list = null;
            return;
        } while (!Element.parseOptionalSeparator(text, position, parser.symbols.openingBrackets[bracketIndex]));
        this.list = new LinkedList<Object>();
        do {
            if (position.getIndex() >= length) {
                throw this.missingCharacter(parser.symbols.close, length);
            }
            if (Element.parseOptionalSeparator(text, position, parser.symbols.quote)) {
                lower = position.getIndex();
                upper = text.indexOf(parser.symbols.quote, lower);
                if (upper < lower) {
                    position.setErrorIndex(++lower);
                    throw this.missingCharacter(parser.symbols.quote, lower);
                }
                this.list.add(text.substring(lower, upper).trim());
                position.setIndex(upper + 1);
                continue;
            }
            lower = position.getIndex();
            if (!Character.isUnicodeIdentifierStart(text.charAt(lower))) {
                Number number = parser.parseNumber(text, position);
                if (number == null) {
                    throw this.unparsableString(text, position);
                }
                this.list.add(number);
                continue;
            }
            this.list.add(new Element(parser, text, position));
        } while (Element.parseOptionalSeparator(text, position, parser.symbols.separator));
        this.parseSeparator(text, position, parser.symbols.closingBrackets[bracketIndex]);
    }

    private static boolean parseOptionalSeparator(String text, ParsePosition position, char separator) {
        int index;
        int length = text.length();
        for (index = position.getIndex(); index < length; ++index) {
            char c = text.charAt(index);
            if (Character.isWhitespace(c)) {
                continue;
            }
            if (c != separator) break;
            position.setIndex(++index);
            return true;
        }
        position.setIndex(index);
        return false;
    }

    private void parseSeparator(String text, ParsePosition position, char separator) throws ParseException {
        if (!Element.parseOptionalSeparator(text, position, separator)) {
            position.setErrorIndex(position.getIndex());
            throw this.unparsableString(text, position);
        }
    }

    public ParseException parseFailed(Exception cause, String message) {
        if (message == null) {
            message = cause.getLocalizedMessage();
        }
        ParseException exception = new ParseException(this.complete(message), this.offset);
        exception = Element.trim("parseFailed", exception);
        exception.initCause(cause);
        return exception;
    }

    private ParseException unparsableString(String text, ParsePosition position) {
        int errorIndex = position.getErrorIndex();
        String message = LoggedFormat.formatUnparsable(text, position.getIndex(), errorIndex, null);
        message = this.complete(message);
        return Element.trim("unparsableString", new ParseException(message, errorIndex));
    }

    private ParseException missingCharacter(char c, int position) {
        return Element.trim("missingCharacter", new ParseException(this.complete(Errors.format(97, Character.valueOf(c))), position));
    }

    private ParseException missingParameter(String key) {
        int error = this.offset;
        if (this.keyword != null) {
            error += this.keyword.length();
        }
        return Element.trim("missingParameter", new ParseException(this.complete(Errors.format(99, key)), error));
    }

    private String complete(String message) {
        if (this.keyword != null) {
            message = Errors.format(84, this.keyword) + ' ' + message;
        }
        return message;
    }

    private static ParseException trim(String factory, ParseException exception) {
        StackTraceElement[] trace = exception.getStackTrace();
        if (trace != null && trace.length != 0 && factory.equals(trace[0].getMethodName())) {
            trace = XArray.remove(trace, 0, 1);
            exception.setStackTrace(trace);
        }
        return exception;
    }

    public boolean isRoot() {
        return this.offset == 0;
    }

    public double pullDouble(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingParameter(key);
    }

    public int pullInteger(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new ParseException(this.complete(Errors.format(58, key, number)), this.offset);
            }
            return number.intValue();
        }
        throw this.missingParameter(key);
    }

    public String pullString(String key) throws ParseException {
        String optionalString = this.pullOptionalString(key);
        if (optionalString != null) {
            return optionalString;
        }
        throw this.missingParameter(key);
    }

    public String pullOptionalString(String key) {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        return null;
    }

    public Element pullElement(String key) throws ParseException {
        Element element = this.pullOptionalElement(key);
        if (element != null) {
            return element;
        }
        throw this.missingParameter(key);
    }

    public Element pullOptionalElement(String key) {
        key = key.toUpperCase();
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list == null || !element.keyword.equals(key)) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public Element pullVoidElement(String key) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        throw this.missingParameter(key);
    }

    public Element pullOptionalVoidElement() throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public Object peek() {
        return this.list.isEmpty() ? null : this.list.get(0);
    }

    public void close() throws ParseException {
        if (this.list != null && !this.list.isEmpty()) {
            throw new ParseException(this.complete(Errors.format(176, this.list.get(0))), this.offset + this.keyword.length());
        }
    }

    public String toString() {
        return this.keyword;
    }

    public void print(PrintWriter out, int level) {
        int tabWidth = 4;
        out.print(Utilities.spaces(4 * level));
        out.println(this.keyword);
        if (this.list == null) {
            return;
        }
        for (Object object : this.list) {
            if (object instanceof Element) {
                ((Element)object).print(out, level + 1);
                continue;
            }
            out.print(Utilities.spaces(4 * (level + 1)));
            out.println(object);
        }
    }
}

