/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.referencing.operation.DefaultSingleOperation;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PassThroughOperation;

public class DefaultPassThroughOperation
extends DefaultSingleOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    protected final Operation operation;

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Operation operation, int firstAffectedOrdinate, int numTrailingOrdinates) {
        this(properties, sourceCRS, targetCRS, operation, PassThroughTransform.create(firstAffectedOrdinate, operation.getMathTransform(), numTrailingOrdinates));
    }

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Operation operation, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, transform);
        this.operation = operation;
        DefaultPassThroughOperation.ensureNonNull("operation", operation);
        DefaultPassThroughOperation.ensureValidDimension(operation.getSourceCRS(), transform.getSourceDimensions());
        DefaultPassThroughOperation.ensureValidDimension(operation.getTargetCRS(), transform.getTargetDimensions());
    }

    private static void ensureValidDimension(CoordinateReferenceSystem crs, int dim) {
        if (crs.getCoordinateSystem().getDimension() > dim) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public int[] getModifiedCoordinates() {
        if (!(this.transform instanceof PassThroughTransform)) {
            throw new UnsupportedImplementationException(this.transform.getClass());
        }
        return ((PassThroughTransform)this.transform).getModifiedCoordinates();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        String name = super.formatWKT(formatter);
        try {
            int[] ordinates;
            for (int ordinate : ordinates = this.getModifiedCoordinates()) {
                formatter.append(ordinate);
            }
        }
        catch (UnsupportedOperationException exception) {
            formatter.setInvalidWKT(PassThroughOperation.class);
        }
        formatter.append(this.operation);
        return name;
    }
}

