/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.geotools.measure.BaseUnitFormatter;
import org.geotools.measure.UnitDefinition;
import org.geotools.measure.UnitDefinitions;
import org.geotools.measure.UnitFormatter;
import org.geotools.measure.Units;
import tech.units.indriya.unit.TransformedUnit;

public final class WktUnitFormat {
    private static final List<UnitDefinition> UNIT_DEFINITIONS = Stream.of(UnitDefinitions.DIMENSIONLESS, UnitDefinitions.CONSTANTS, UnitDefinitions.SI_BASE, UnitDefinitions.SI_DERIVED, UnitDefinitions.NON_SI, UnitDefinitions.US_CUSTOMARY, UnitDefinitions.WKT).flatMap(Collection::stream).collect(Collectors.toList());
    private static final WktUnitFormatterImpl INSTANCE = new WktUnitFormatterImpl(UNIT_DEFINITIONS);

    public static UnitFormatter getInstance() {
        return INSTANCE;
    }

    private WktUnitFormat() {
    }

    static class UnitWrapper {
        private final Unit<?> unit;

        public UnitWrapper(Unit<?> unit) {
            this.unit = unit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnitWrapper) {
                return Units.equals(this.unit, ((UnitWrapper)obj).getUnit());
            }
            return false;
        }

        public Unit<?> getUnit() {
            return this.unit;
        }

        public int hashCode() {
            if (this.unit instanceof TransformedUnit) {
                Unit<?> systemUnit = this.unit.getSystemUnit();
                try {
                    float factor1 = (float)this.unit.getConverterToAny(systemUnit).convert(1.0);
                    return Objects.hash(systemUnit, Float.floatToIntBits(factor1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.unit.hashCode();
        }

        public String toString() {
            return this.unit.toString();
        }
    }

    static class WktUnitFormatterImpl
    extends BaseUnitFormatter
    implements UnitFormatter {
        private HashMap<UnitWrapper, Unit<?>> unitWrapperToUnitMap;

        WktUnitFormatterImpl(List<UnitDefinition> unitDefinitions) {
            super(unitDefinitions);
        }

        @Override
        protected void addUnit(Unit<?> unit) {
            if (this.unitWrapperToUnitMap == null) {
                this.unitWrapperToUnitMap = new HashMap();
            }
            this.unitWrapperToUnitMap.put(new UnitWrapper(unit), unit);
        }

        public <Q extends Quantity<Q>> Unit<Q> getEquivalentUnit(Unit<Q> unit) {
            return INSTANCE.unitWrapperToUnitMap.getOrDefault(new UnitWrapper(unit), unit);
        }
    }
}

