/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.cog.CogImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogSourceSPIProvider;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.data.DataSourceException;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;

public class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final String GEOTIFF_WRITE_NODATA_KEY = "geotiff.writenodata";
    private static final boolean DEFAULT_WRITE_NODATA;
    private static final Logger LOGGER;
    public static final DefaultParameterDescriptor<Boolean> WRITE_TFW;
    public static final DefaultParameterDescriptor<Boolean> WRITE_NODATA;
    public static final DefaultParameterDescriptor<Boolean> RETAIN_AXES_ORDER;
    static final TIFFImageWriterSpi IMAGEIO_WRITER_FACTORY;
    private static final TIFFImageReaderSpi IMAGEIO_READER_FACTORY;
    private static final CogImageReaderSpi COG_IMAGE_READER_SPI;

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org/geotiff/spec/geotiffhome.html");
        this.readParameters = new ParameterGroup(new DefaultParameterDescriptorGroup(this.mInfo, READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, SUGGESTED_TILE_SIZE, RESCALE_PIXELS));
        this.writeParameters = new ParameterGroup(new DefaultParameterDescriptorGroup(this.mInfo, RETAIN_AXES_ORDER, WRITE_NODATA, AbstractGridFormat.GEOTOOLS_WRITE_PARAMS, AbstractGridFormat.PROGRESS_LISTENER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean accepts(Object o, Hints hints) {
        block79: {
            block77: {
                block78: {
                    block75: {
                        block76: {
                            block73: {
                                block74: {
                                    block71: {
                                        block72: {
                                            block69: {
                                                block70: {
                                                    block67: {
                                                        block68: {
                                                            if (o == null) {
                                                                return false;
                                                            }
                                                            reader = null;
                                                            inputStream = null;
                                                            closeMe = true;
                                                            if (o instanceof CogSourceSPIProvider) {
                                                                inputStream = ((CogSourceSPIProvider)o).getStream();
                                                                reader = GeoTiffFormat.COG_IMAGE_READER_SPI.createReaderInstance();
                                                            } else if (o instanceof ImageInputStream) {
                                                                closeMe = false;
                                                                inputStream = (ImageInputStream)o;
                                                            } else {
                                                                if (o instanceof URL) {
                                                                    url = (URL)o;
                                                                    o = URLs.urlToFile(url);
                                                                }
                                                                inputStream = ImageIO.createImageInputStream(o);
                                                            }
                                                            if (inputStream != null) break block67;
                                                            if (GeoTiffFormat.LOGGER.isLoggable(Level.FINE)) {
                                                                GeoTiffFormat.LOGGER.fine("Unable to get an ImageInputStream");
                                                            }
                                                            url = false;
                                                            if (reader == null) break block68;
                                                            try {
                                                                reader.dispose();
                                                            }
                                                            catch (Exception var7_10) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (closeMe && inputStream != null) {
                                                            try {
                                                                inputStream.close();
                                                            }
                                                            catch (Throwable var7_11) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return url;
                                                    }
                                                    if (reader != null) ** GOTO lbl59
                                                    if (GeoTiffFormat.IMAGEIO_READER_FACTORY.canDecodeInput(inputStream)) break block69;
                                                    url = false;
                                                    if (reader == null) break block70;
                                                    try {
                                                        reader.dispose();
                                                    }
                                                    catch (Exception var7_12) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (closeMe && inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Throwable var7_13) {
                                                        // empty catch block
                                                    }
                                                }
                                                return url;
                                            }
                                            reader = GeoTiffFormat.IMAGEIO_READER_FACTORY.createReaderInstance();
lbl59:
                                            // 2 sources

                                            inputStream.mark();
                                            reader.setInput(inputStream);
                                            metadata = reader.getImageMetadata(0);
                                            if (metadata != null) break block71;
                                            var7_14 = false;
                                            if (reader == null) break block72;
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception var8_17) {
                                                // empty catch block
                                            }
                                        }
                                        if (closeMe && inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Throwable var8_18) {
                                                // empty catch block
                                            }
                                        }
                                        return var7_14;
                                    }
                                    metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                                    if (!metadataAdapter.hasGeoKey() && GeoTiffFormat.LOGGER.isLoggable(Level.FINE)) {
                                        GeoTiffFormat.LOGGER.fine("Unable to find geokey directory for this tif file");
                                    }
                                    if (!metadataAdapter.hasModelTrasformation() && (!metadataAdapter.hasPixelScales() || !metadataAdapter.hasTiePoints())) break block73;
                                    var8_19 = true;
                                    if (reader == null) break block74;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception var9_23) {
                                        // empty catch block
                                    }
                                }
                                if (closeMe && inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable var9_24) {
                                        // empty catch block
                                    }
                                }
                                return var8_19;
                            }
                            raster2Model = GeoTiffReader.parseWorldFile(o);
                            if (raster2Model == null && (mif = GeoTiffReader.parseMapInfoFile(o)) != null) {
                                raster2Model = mif.getTransform();
                            }
                            if (raster2Model == null) break block75;
                            mif = true;
                            if (reader == null) break block76;
                            try {
                                reader.dispose();
                            }
                            catch (Exception var10_27) {
                                // empty catch block
                            }
                        }
                        if (closeMe && inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable var10_28) {
                                // empty catch block
                            }
                        }
                        return mif;
                    }
                    modelTiePoints = metadataAdapter.getModelTiePoints();
                    if (modelTiePoints == null || modelTiePoints.length <= 1) break block77;
                    var10_29 = true;
                    if (reader == null) break block78;
                    try {
                        reader.dispose();
                    }
                    catch (Exception var11_31) {
                        // empty catch block
                    }
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable var11_32) {
                        // empty catch block
                    }
                }
                return var10_29;
            }
            if (GeoTiffFormat.LOGGER.isLoggable(Level.FINE)) {
                GeoTiffFormat.LOGGER.fine("Unable to find georeferencing for this tif file");
            }
            var10_30 = false;
            if (reader == null) break block79;
            try {
                reader.dispose();
            }
            catch (Exception var11_33) {
                // empty catch block
            }
        }
        if (closeMe && inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable var11_34) {
                // empty catch block
            }
        }
        return var10_30;
        catch (Throwable e) {
            try {
                if (GeoTiffFormat.LOGGER.isLoggable(Level.FINE)) {
                    GeoTiffFormat.LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                var7_16 = false;
                return var7_16;
            }
            catch (Throwable var12_35) {
                throw var12_35;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Exception var8_21) {}
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable var8_22) {}
                }
            }
        }
    }

    @Override
    public GeoTiffReader getReader(Object source) {
        return this.getReader(source, null);
    }

    @Override
    public GeoTiffReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                File file = URLs.urlToFile(url);
                return new GeoTiffReader(file, hints);
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }

    static {
        String geotiffWriteNodataProperty = System.getProperty(GEOTIFF_WRITE_NODATA_KEY, "true");
        DEFAULT_WRITE_NODATA = Boolean.valueOf(geotiffWriteNodataProperty);
        LOGGER = Logging.getLogger(GeoTiffFormat.class);
        WRITE_TFW = new DefaultParameterDescriptor<Boolean>("WRITE_TFW", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
        WRITE_NODATA = new DefaultParameterDescriptor<Boolean>("WRITE_NODATA", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.valueOf(DEFAULT_WRITE_NODATA)){
            private static final long serialVersionUID = 476944281037266742L;

            @Override
            public Boolean getDefaultValue() {
                return Boolean.valueOf(System.getProperty(GeoTiffFormat.GEOTIFF_WRITE_NODATA_KEY, "true"));
            }
        };
        RETAIN_AXES_ORDER = new DefaultParameterDescriptor<Boolean>("RETAIN_AXES_ORDER", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
        IMAGEIO_WRITER_FACTORY = new TIFFImageWriterSpi();
        IMAGEIO_READER_FACTORY = new TIFFImageReaderSpi();
        COG_IMAGE_READER_SPI = new CogImageReaderSpi();
    }
}

