/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.string;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class URLEncodeFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("strURLEncode", String.class, FunctionNameImpl.parameter("encodeable", String.class), FunctionNameImpl.parameter("formUrlEncode", Boolean.class, 0, 1));

    public URLEncodeFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        String stringToBeEncoded;
        try {
            stringToBeEncoded = this.getExpression(0).evaluate(feature, String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function strURLEncode argument #0 - expected type String");
        }
        Boolean formUrlEncode = Boolean.FALSE;
        if (this.params.size() == 2) {
            try {
                formUrlEncode = this.getExpression(1).evaluate(feature, Boolean.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Filter Function problem for function strURLEncode argument #1 - expected type Boolean");
            }
        }
        try {
            String encoded = URLEncoder.encode(stringToBeEncoded, "utf-8");
            if (!formUrlEncode.booleanValue()) {
                encoded = encoded.replaceAll("\\+", "%20");
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Filter Function problem for function strURLEncode argument #0 - " + e.getMessage());
        }
    }
}

