/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class CollectionConverterFactory
implements ConverterFactory {
    protected static final Converter CollectionToCollection = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (target.isInstance(source)) {
                return target.cast(source);
            }
            Collection<Object> converted = CollectionConverterFactory.newCollection(target);
            if (converted != null) {
                Collection castSource = (Collection)source;
                converted.addAll(castSource);
            }
            return target.cast(converted);
        }
    };
    protected static final Converter CollectionToArray = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Collection s = (Collection)source;
            Object array = Array.newInstance(target.getComponentType(), s.size());
            try {
                int x = 0;
                for (Object o : s) {
                    Array.set(array, x++, o);
                }
                return target.cast(array);
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    protected static final Converter ArrayToCollection = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Collection<Object> collection = CollectionConverterFactory.newCollection(target);
            if (collection != null) {
                int length = Array.getLength(source);
                for (int i = 0; i < length; ++i) {
                    collection.add(Array.get(source, i));
                }
            }
            return target.cast(collection);
        }
    };
    protected static final Converter ArrayToArray = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Class<?> s = source.getClass().getComponentType();
            Class<?> t = target.getComponentType();
            if (t.isAssignableFrom(s)) {
                int length = Array.getLength(source);
                Object converted = Array.newInstance(t, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(converted, i, Array.get(source, i));
                }
                Object cast = converted;
                return (T)cast;
            }
            return null;
        }
    };

    protected static Collection<Object> newCollection(Class target) throws Exception {
        if (target.isInterface()) {
            if (List.class.isAssignableFrom(target)) {
                return new ArrayList<Object>();
            }
            if (SortedSet.class.isAssignableFrom(target)) {
                return new TreeSet<Object>();
            }
            if (Set.class.isAssignableFrom(target)) {
                return new HashSet<Object>();
            }
            return null;
        }
        Collection result = (Collection)target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return result;
    }

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if ((Collection.class.isAssignableFrom(source) || source.isArray()) && (Collection.class.isAssignableFrom(target) || target.isArray())) {
            if (Collection.class.isAssignableFrom(source) && Collection.class.isAssignableFrom(target)) {
                return CollectionToCollection;
            }
            if (source.isArray() && target.isArray()) {
                return ArrayToArray;
            }
            if (Collection.class.isAssignableFrom(source) && target.isArray()) {
                return CollectionToArray;
            }
            if (source.isArray() && Collection.class.isAssignableFrom(target)) {
                return ArrayToCollection;
            }
        }
        return null;
    }
}

