/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import it.geosolutions.jaiext.utilities.shape.LiteShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.prep.PreparedGeometry;

public class VectorBinarizeOpImage
extends SourcelessOpImage {
    private final PreparedGeometry geom;
    private final Shape shape;
    private Raster solidTile;
    private Raster blankTile;
    public static final boolean DEFAULT_ANTIALIASING = false;
    private boolean antiAliasing = false;
    private GeometryFactory gf = new GeometryFactory();

    public VectorBinarizeOpImage(SampleModel sm, Map configuration, int minX, int minY, int width, int height, PreparedGeometry geom, boolean antiAliasing) {
        super(VectorBinarizeOpImage.buildLayout(minX, minY, width, height, sm), configuration, sm, minX, minY, width, height);
        this.geom = geom;
        this.shape = new LiteShape(geom.getGeometry());
        this.antiAliasing = antiAliasing;
    }

    static ImageLayout buildLayout(int minX, int minY, int width, int height, SampleModel sm) {
        ImageLayout il = new ImageLayout();
        il.setMinX(minX);
        il.setMinY(minY);
        il.setWidth(width);
        il.setHeight(height);
        il.setTileWidth(sm.getWidth());
        il.setTileHeight(sm.getHeight());
        il.setSampleModel(sm);
        if (!il.isValid(16)) {
            il.setTileGridXOffset(il.getMinX(null));
        }
        if (!il.isValid(32)) {
            il.setTileGridYOffset(il.getMinY(null));
        }
        return il;
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        int x = this.tileXToX(tileX);
        int y = this.tileYToY(tileY);
        Raster tile = this.getTileRaster(x, y);
        Raster result = tile.createChild(0, 0, this.tileWidth, this.tileHeight, x, y, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Raster getTileRaster(int minX, int minY) {
        Polygon testRect = this.getTestRect(minX, minY);
        try {
            PreparedGeometry preparedGeometry = this.geom;
            synchronized (preparedGeometry) {
                if (this.geom.contains((Geometry)testRect)) {
                    return this.getSolidTile();
                }
                if (this.geom.disjoint((Geometry)testRect)) {
                    return this.getBlankTile();
                }
            }
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
        return this.drawGeometry(minX, minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster drawGeometry(int minX, int minY) {
        int offset = this.antiAliasing ? 2 : 0;
        SampleModel tileSampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        WritableRaster raster = RasterFactory.createWritableRaster(tileSampleModel, new Point(0, 0));
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        Graphics2D graphics = null;
        try {
            graphics = bi.createGraphics();
            graphics.setClip(-offset, -offset, this.tileWidth + offset * 2, this.tileHeight + offset * 2);
            graphics.translate(-minX, -minY);
            if (this.antiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics.setColor(Color.WHITE);
            graphics.fill(this.shape);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return raster;
    }

    private Raster getSolidTile() {
        if (this.solidTile == null) {
            this.solidTile = this.constantTile(1);
        }
        return this.solidTile;
    }

    private Raster getBlankTile() {
        if (this.blankTile == null) {
            this.blankTile = this.constantTile(0);
        }
        return this.blankTile;
    }

    private Raster constantTile(int value) {
        WritableRaster raster = RasterFactory.createWritableRaster(this.sampleModel, new Point(0, 0));
        int dataType = this.sampleModel.getTransferType();
        int numBands = this.sampleModel.getNumBands();
        if (dataType != 0) {
            throw new IllegalArgumentException("The code works only if the sample model data type is BYTE");
        }
        if (numBands != 1) {
            throw new IllegalArgumentException("The code works only for single band rasters!");
        }
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        if (value == 1) {
            Arrays.fill(dataBuffer.getData(), (byte)-1);
        }
        return raster;
    }

    private Polygon getTestRect(int x, int y) {
        Coordinate[] copyCoords = new Coordinate[5];
        for (int i = 0; i < 5; ++i) {
            int xx = x;
            int yy = y;
            if (i == 1 || i == 2) {
                yy = y + this.tileHeight;
            }
            if (i == 2 || i == 3) {
                xx = x + this.tileWidth;
            }
            copyCoords[i] = new Coordinate((double)xx, (double)yy);
        }
        CoordinateArraySequence seq = new CoordinateArraySequence(copyCoords, 2);
        return this.gf.createPolygon(this.gf.createLinearRing((CoordinateSequence)seq), null);
    }
}

