/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class RasterAccessorExt
extends RasterAccessor {
    private static final int GRAY_EXPANSION_MASK_SHIFT = 11;
    private static final int GRAY_EXPANSION_MASK_SIZE = 1;
    public static final int GRAY_EXPANSION_MASK = 6144;
    public static final int UNEXPANDED = 0;
    public static final int GRAY_TO_RGB = 2048;
    public static final int GRAY_SCALE = 4096;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RasterAccessorExt(Raster raster, Rectangle rect, RasterFormatTag rft, ColorModel theColorModel, int targetBands, int targetDataType) {
        super(raster, rect, rft, theColorModel);
        int numBands = rft.getNumBands();
        if (RasterAccessorExt.isGray(theColorModel, numBands) && (rft.getFormatTagID() & 0x1800) == 2048) {
            int newNumBands = targetBands;
            boolean sourceAlpha = theColorModel.hasAlpha();
            int[] newBandDataOffsets = new int[newNumBands];
            for (int i = 0; i < newBandDataOffsets.length; ++i) {
                newBandDataOffsets[i] = this.bandDataOffsets[0];
            }
            int[] newBandOffsets = new int[newNumBands];
            for (int i = 0; i < newBandOffsets.length; ++i) {
                newBandOffsets[i] = this.bandOffsets[0];
            }
            if (sourceAlpha) {
                newBandDataOffsets[newBandDataOffsets.length - 1] = this.bandDataOffsets[this.bandDataOffsets.length - 1];
                newBandOffsets[newBandOffsets.length - 1] = this.bandOffsets[this.bandOffsets.length - 1];
            }
            switch (this.formatTagID & 0x7F) {
                case 0: {
                    byte[] byteDataArray = this.byteDataArrays[0];
                    this.byteDataArrays = new byte[newNumBands][];
                    for (int i = 0; i < newNumBands; ++i) {
                        this.byteDataArrays[i] = byteDataArray;
                    }
                    if (numBands != 1 || newNumBands != 4) break;
                    byte[] alpha = new byte[byteDataArray.length];
                    Arrays.fill(alpha, (byte)-1);
                    this.byteDataArrays[3] = alpha;
                    break;
                }
                case 1: 
                case 2: {
                    short[] shortDataArray = this.shortDataArrays[0];
                    this.shortDataArrays = new short[newNumBands][];
                    for (int i = 0; i < newNumBands; ++i) {
                        this.shortDataArrays[i] = shortDataArray;
                    }
                    if (numBands != 1 || newNumBands != 4) break;
                    short[] alpha = new short[shortDataArray.length];
                    Arrays.fill(alpha, (short)Short.MAX_VALUE);
                    this.shortDataArrays[3] = alpha;
                    break;
                }
                case 3: {
                    int[] intDataArray = this.intDataArrays[0];
                    if (raster.getDataBuffer().getDataType() == 1 && targetDataType == 0) {
                        int length = intDataArray.length;
                        for (int i = 0; i < length; ++i) {
                            int sample = intDataArray[i];
                            intDataArray[i] = RasterAccessorExt.shortToByte(sample);
                        }
                    }
                    this.intDataArrays = new int[newNumBands][];
                    for (int i = 0; i < newNumBands; ++i) {
                        this.intDataArrays[i] = intDataArray;
                    }
                    if (numBands != 1 || newNumBands != 4) break;
                    int[] alpha = new int[intDataArray.length];
                    Arrays.fill(alpha, Integer.MAX_VALUE);
                    this.intDataArrays[3] = alpha;
                    break;
                }
                case 4: {
                    float[] floatDataArray = this.floatDataArrays[0];
                    this.floatDataArrays = new float[newNumBands][];
                    for (int i = 0; i < newNumBands; ++i) {
                        this.floatDataArrays[i] = floatDataArray;
                    }
                    break;
                }
                case 5: {
                    double[] doubleDataArray = this.doubleDataArrays[0];
                    this.doubleDataArrays = new double[newNumBands][];
                    for (int i = 0; i < newNumBands; ++i) {
                        this.doubleDataArrays[i] = doubleDataArray;
                    }
                    break;
                }
            }
            this.numBands = newNumBands;
            this.bandDataOffsets = newBandDataOffsets;
            this.bandOffsets = newBandDataOffsets;
            return;
        } else {
            SampleModel sampleModel = raster.getSampleModel();
            if (numBands == 1 && (rft.getFormatTagID() & 0x1800) == 4096) {
                int sourceDataType = sampleModel.getDataType();
                if (targetDataType != 1 || sourceDataType != 0) throw new IllegalArgumentException("Cannot perform gray rescaling from data type " + sourceDataType + " to data type " + targetDataType);
                for (int i = 0; i < this.intDataArrays.length; ++i) {
                    int[] pixels = this.intDataArrays[i];
                    for (int j = 0; j < pixels.length; ++j) {
                        pixels[j] = RasterAccessorExt.byteToShort(pixels[j]);
                    }
                }
                return;
            } else {
                if (numBands != 3 || targetBands != 4 || sampleModel.getDataType() != 0) return;
                if (!(sampleModel instanceof ComponentSampleModel)) throw new IllegalArgumentException("Expansion from RGB to RGBA on this sample model not supported: " + sampleModel);
                byte[][] newDataArrays = new byte[targetBands][];
                for (int i = 0; i < numBands; ++i) {
                    newDataArrays[i] = new byte[raster.getWidth() * raster.getHeight()];
                }
                int width = this.getWidth();
                int offset = this.scanlineStride - width * numBands;
                int interleavedPos = 0;
                int pos = 0;
                int height = this.getHeight();
                int[] bandOffsets = ((ComponentSampleModel)sampleModel).getBandOffsets();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        for (int b = 0; b < numBands; ++b) {
                            newDataArrays[b][pos] = this.byteDataArrays[b][interleavedPos + bandOffsets[b]];
                        }
                        ++pos;
                    }
                    interleavedPos += offset;
                }
                byte[] alpha = new byte[raster.getWidth() * raster.getHeight()];
                Arrays.fill(alpha, (byte)-1);
                newDataArrays[3] = alpha;
                this.byteDataArrays = newDataArrays;
                int[] newBandDataOffsets = new int[targetBands];
                for (int i = 0; i < newBandDataOffsets.length; ++i) {
                    newBandDataOffsets[i] = 0;
                }
                int[] newBandOffsets = new int[targetBands];
                for (int i = 0; i < newBandOffsets.length; ++i) {
                    newBandOffsets[i] = 0;
                }
                this.bandOffsets = newBandOffsets;
                this.bandDataOffsets = newBandDataOffsets;
                this.scanlineStride = width;
                this.pixelStride = 1;
                this.numBands = 4;
            }
        }
    }

    static boolean isGray(ColorModel theColorModel, int numBands) {
        return numBands == 1 || numBands == 2 && theColorModel.hasAlpha();
    }

    private static final int shortToByte(int sample) {
        return (int)Math.round((double)sample / 65536.0 * 255.0);
    }

    private static final int byteToShort(int theByte) {
        double d = theByte;
        return (int)Math.round(d / 255.0 * 65535.0);
    }

    public static RasterFormatTag[] findCompatibleTags(RenderedImage[] srcs, RenderedImage dst) {
        RasterFormatTag[] tags;
        block3: {
            block2: {
                tags = RasterAccessor.findCompatibleTags(srcs, dst);
                if (dst.getSampleModel().getNumBands() <= 1) break block2;
                for (int i = 0; i < srcs.length; ++i) {
                    RenderedImage src = srcs[i];
                    int numBands = src.getSampleModel().getNumBands();
                    if (numBands != 1 && numBands != 2 || src.getColorModel() instanceof IndexColorModel) continue;
                    tags[i] = RasterAccessorExt.applyMask(src, tags[i], 2048);
                }
                break block3;
            }
            if (dst.getSampleModel().getNumBands() != 1 || dst.getColorModel() instanceof IndexColorModel) break block3;
            int destinationDataType = dst.getSampleModel().getDataType();
            for (int i = 0; i < srcs.length; ++i) {
                RenderedImage src = srcs[i];
                int sourceDataType = src.getSampleModel().getDataType();
                if (destinationDataType == sourceDataType) continue;
                tags[i] = RasterAccessorExt.applyMask(src, tags[i], 4096);
            }
        }
        return tags;
    }

    private static RasterFormatTag applyMask(RenderedImage src, RasterFormatTag oldTag, int mask) {
        int tagId = oldTag.getFormatTagID() | mask;
        RasterFormatTag newTag = new RasterFormatTag(src.getSampleModel(), tagId);
        return newTag;
    }

    public static Range expandNoData(Range noData, RasterFormatTag rft, RenderedImage sourceImage, RenderedImage destImage) {
        int formatTagID = rft.getFormatTagID();
        int targetDataType = destImage.getSampleModel().getDataType();
        int formatDataType = formatTagID & 0x7F;
        int sourceDataType = sourceImage.getSampleModel().getDataType();
        int destinationDataType = destImage.getSampleModel().getDataType();
        if (rft.getNumBands() == 1 && (rft.getFormatTagID() & 0x1800) == 2048 && formatDataType == 3 && sourceDataType == 1 && destinationDataType == 0) {
            int min = noData.getMin().intValue();
            int max = noData.getMax().intValue();
            byte scaledMin = (byte)(RasterAccessorExt.shortToByte(min) & 0xFF);
            byte scaledMax = (byte)(RasterAccessorExt.shortToByte(max) & 0xFF);
            return RangeFactory.create(scaledMin, noData.isMinIncluded(), scaledMax, noData.isMaxIncluded());
        }
        if (rft.getNumBands() == 1 && (rft.getFormatTagID() & 0x1800) == 4096) {
            if (targetDataType == 1 && sourceDataType == 0) {
                int min = noData.getMin().intValue();
                int max = noData.getMax().intValue();
                int expandedMin = RasterAccessorExt.byteToShort(min);
                int expandedMax = RasterAccessorExt.byteToShort(max);
                return RangeFactory.create(expandedMin, noData.isMinIncluded(), expandedMax, noData.isMaxIncluded());
            }
            throw new IllegalArgumentException("Cannot perform gray rescaling from data type " + sourceDataType + " to data type " + targetDataType);
        }
        return noData;
    }

    static boolean isPaletteExpansionRequired(RenderedImage sourceImage, int formatTagID) {
        return (formatTagID & 0x600) == 512 && sourceImage.getColorModel() instanceof IndexColorModel;
    }
}

