/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.I18N;
import it.geosolutions.imageioimpl.plugins.tiff.PredictorDecompressor;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2 && predictor != 3) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = predictor;
    }

    @Override
    public synchronized void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        PredictorDecompressor predictorDecompressor = new PredictorDecompressor(this.predictor, this.bitsPerSample, this.sampleFormat, this.samplesPerPixel, this.stream.getByteOrder());
        predictorDecompressor.validate();
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.inflater.setInput(srcData);
        try {
            this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
        }
        catch (DataFormatException dfe) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
        }
        this.inflater.reset();
        predictorDecompressor.decompress(buf, bufOffset, dstOffset, this.srcHeight, this.srcWidth, bytesPerRow);
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

