/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FallbackFunction;
import org.geotools.filter.FunctionFactory;
import org.geotools.util.factory.Hints;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionFinder {
    private volatile Map<Name, FunctionFactory> functionFactoryCache;

    public FunctionFinder(Hints hints) {
    }

    public List<FunctionName> getAllFunctionDescriptions() {
        Set<FunctionFactory> functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        ArrayList<FunctionName> allFunctionDescriptions = new ArrayList<FunctionName>();
        for (FunctionFactory factory : functionFactories) {
            List<FunctionName> functionNames = factory.getFunctionNames();
            allFunctionDescriptions.addAll(functionNames);
        }
        Collections.sort(allFunctionDescriptions, (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        return Collections.unmodifiableList(allFunctionDescriptions);
    }

    public FunctionName findFunctionDescription(String name) {
        return this.findFunctionDescription(new NameImpl(name));
    }

    public FunctionName findFunctionDescription(Name name) {
        Set<FunctionFactory> functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory factory : functionFactories) {
            List<FunctionName> functionNames = factory.getFunctionNames();
            for (FunctionName description : functionNames) {
                if (!description.getFunctionName().equals(name)) continue;
                return description;
            }
        }
        return null;
    }

    public Function findFunction(String name) {
        return this.findFunction(new NameImpl(name));
    }

    public Function findFunction(Name name) {
        return this.findFunction(name, null);
    }

    public Function findFunction(String name, List<Expression> parameters) {
        return this.findFunction(this.toName(name), parameters);
    }

    Name toName(String name) {
        if (name.contains(":")) {
            String[] split = name.split(":");
            return new NameImpl(split[0], ":", split[1]);
        }
        if (name.contains("#")) {
            String[] split = name.split("#");
            return new NameImpl(split[0], "#", split[1]);
        }
        return new NameImpl(name);
    }

    public Function findFunction(Name name, List<Expression> parameters) {
        return this.findFunction(name, parameters, null);
    }

    public Function findFunction(String name, List<Expression> parameters, Literal fallback) {
        return this.findFunction(new NameImpl(name), parameters, fallback);
    }

    public Function findFunction(Name name, List<Expression> parameters, Literal fallback) {
        Function f = this.findFunctionInternal(name, parameters, fallback);
        if (f == null && name.getLocalPart().endsWith("Function")) {
            String local = name.getLocalPart();
            local = local.substring(0, local.length() - "Function".length());
            name = new NameImpl(name.getNamespaceURI(), name.getSeparator(), local);
            f = this.findFunctionInternal(name, parameters, fallback);
        }
        if (f == null && fallback != null) {
            return new FallbackFunction(name, parameters, fallback);
        }
        if (f != null) {
            return f;
        }
        throw new RuntimeException("Unable to find function " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function findFunctionInternal(Name name, List<Expression> parameters, Literal fallback) {
        if (this.functionFactoryCache == null) {
            FunctionFinder functionFinder = this;
            synchronized (functionFinder) {
                if (this.functionFactoryCache == null) {
                    this.functionFactoryCache = this.lookupFunctions();
                }
            }
        }
        if (this.functionFactoryCache.containsKey(name)) {
            FunctionFactory functionFactory = this.functionFactoryCache.get(name);
            return functionFactory.function(name, parameters, fallback);
        }
        Function f = null;
        for (FunctionFactory ff : CommonFactoryFinder.getFunctionFactories(null)) {
            f = ff.function(name, parameters, fallback);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private HashMap<Name, FunctionFactory> lookupFunctions() {
        HashMap<Name, FunctionFactory> result = new HashMap<Name, FunctionFactory>();
        Set<FunctionFactory> functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory ff : functionFactories) {
            for (FunctionName functionName : ff.getFunctionNames()) {
                result.put(functionName.getFunctionName(), ff);
            }
        }
        return result;
    }
}

