/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.FileUtils;

public class ODPackage {
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private File file = null;

    public ODPackage() {
    }

    public ODPackage(ODPackage oDPackage) {
        this();
        for (String string : oDPackage.getEntries()) {
            ODPackageEntry oDPackageEntry = oDPackage.getEntry(string);
            Object object = oDPackageEntry.getData();
            Object object2 = object instanceof byte[] ? object : (object instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)object, this) : CopyUtils.copy(object));
            this.putFile(string, object2, oDPackageEntry.getType(), oDPackageEntry.isCompressed());
        }
        this.file = oDPackage.file;
    }

    public final XMLVersion getVersion() {
        ODXMLDocument oDXMLDocument = this.getContent();
        if (oDXMLDocument == null) {
            return null;
        }
        return oDXMLDocument.getVersion();
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String string) {
        return this.files.get(string);
    }

    protected final Object getData(String string) {
        ODPackageEntry oDPackageEntry = this.getEntry(string);
        return oDPackageEntry == null ? null : oDPackageEntry.getData();
    }

    public final ODXMLDocument getXMLFile(String string) {
        return (ODXMLDocument)this.getData(string);
    }

    public final ODXMLDocument getXMLFile(Document document) {
        for (String string : subdocNames) {
            ODXMLDocument oDXMLDocument = this.getXMLFile(string);
            if (oDXMLDocument == null || oDXMLDocument.getDocument() != document) continue;
            return oDXMLDocument;
        }
        return null;
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile("content.xml");
    }

    public final ODMeta getMeta() {
        ODMeta oDMeta = this.getEntries().contains("meta.xml") ? ODMeta.create(this.getXMLFile("meta.xml")) : ODMeta.create(this.getContent());
        return oDMeta;
    }

    public Document getDocument(String string) {
        ODXMLDocument oDXMLDocument = this.getXMLFile(string);
        return oDXMLDocument == null ? null : oDXMLDocument.getDocument();
    }

    public void putFile(String string, Object object) {
        this.putFile(string, object, null);
    }

    public void putFile(String string, Object object, String string2) {
        this.putFile(string, object, string2, true);
    }

    public void putFile(String string, Object object, String string2, boolean bl) {
        Object object2;
        Object object3;
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (subdocNames.contains(string)) {
            object3 = object instanceof Document ? new ODXMLDocument((Document)object) : (ODXMLDocument)object;
            if (this.getVersion() != null && !((ODXMLDocument)object3).getVersion().equals((Object)this.getVersion())) {
                throw new IllegalArgumentException("version mismatch " + this.getVersion() + " != " + (ODXMLDocument)object3);
            }
            object2 = object3;
        } else {
            if (object != null && !(object instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + string + ": " + object);
            }
            object2 = object;
        }
        object3 = string2 != null ? string2 : FileUtils.findMimeType(string);
        this.files.put(string, new ODPackageEntry(string, (String)object3, object2, bl));
    }

    static {
        subdocNames.add("content.xml");
        subdocNames.add("styles.xml");
        subdocNames.add("meta.xml");
        subdocNames.add("settings.xml");
    }
}

