/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;

public final class ValueRecordsAggregate {
    private static final int MAX_ROW_INDEX = 65535;
    private static final int INDEX_NOT_SET = -1;
    private int firstcell = -1;
    private int lastcell = -1;
    private CellValueRecordInterface[][] records;

    public ValueRecordsAggregate() {
        this(-1, -1, new CellValueRecordInterface[30][]);
    }

    private ValueRecordsAggregate(int n, int n2, CellValueRecordInterface[][] cellValueRecordInterfaceArray) {
        this.firstcell = n;
        this.lastcell = n2;
        this.records = cellValueRecordInterfaceArray;
    }

    public void insertCell(CellValueRecordInterface cellValueRecordInterface) {
        int n;
        CellValueRecordInterface[][] cellValueRecordInterfaceArray;
        short s = cellValueRecordInterface.getColumn();
        int n2 = cellValueRecordInterface.getRow();
        if (n2 >= this.records.length) {
            cellValueRecordInterfaceArray = this.records;
            n = cellValueRecordInterfaceArray.length * 2;
            if (n < n2 + 1) {
                n = n2 + 1;
            }
            this.records = new CellValueRecordInterface[n][];
            System.arraycopy(cellValueRecordInterfaceArray, 0, this.records, 0, cellValueRecordInterfaceArray.length);
        }
        if ((cellValueRecordInterfaceArray = this.records[n2]) == null) {
            n = s + 1;
            if (n < 10) {
                n = 10;
            }
            cellValueRecordInterfaceArray = new CellValueRecordInterface[n];
            this.records[n2] = cellValueRecordInterfaceArray;
        }
        if (s >= cellValueRecordInterfaceArray.length) {
            CellValueRecordInterface[][] cellValueRecordInterfaceArray2 = cellValueRecordInterfaceArray;
            int n3 = cellValueRecordInterfaceArray2.length * 2;
            if (n3 < s + 1) {
                n3 = s + 1;
            }
            cellValueRecordInterfaceArray = new CellValueRecordInterface[n3];
            System.arraycopy(cellValueRecordInterfaceArray2, 0, cellValueRecordInterfaceArray, 0, cellValueRecordInterfaceArray2.length);
            this.records[n2] = cellValueRecordInterfaceArray;
        }
        cellValueRecordInterfaceArray[s] = cellValueRecordInterface;
        if (s < this.firstcell || this.firstcell == -1) {
            this.firstcell = s;
        }
        if (s > this.lastcell || this.lastcell == -1) {
            this.lastcell = s;
        }
    }

    public void removeCell(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        int n = cellValueRecordInterface.getRow();
        if (n >= this.records.length) {
            throw new RuntimeException("cell row is out of range");
        }
        CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[n];
        if (cellValueRecordInterfaceArray == null) {
            throw new RuntimeException("cell row is already empty");
        }
        short s = cellValueRecordInterface.getColumn();
        if (s >= cellValueRecordInterfaceArray.length) {
            throw new RuntimeException("cell column is out of range");
        }
        cellValueRecordInterfaceArray[s] = null;
    }

    public void removeAllCellsValuesForRow(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Specified rowIndex " + n + " is outside the allowable range (0..65535)");
        }
        if (n >= this.records.length) {
            return;
        }
        this.records[n] = null;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public void addMultipleBlanks(MulBlankRecord mulBlankRecord) {
        for (int i = 0; i < mulBlankRecord.getNumColumns(); ++i) {
            BlankRecord blankRecord = new BlankRecord();
            blankRecord.setColumn((short)(i + mulBlankRecord.getFirstColumn()));
            blankRecord.setRow(mulBlankRecord.getRow());
            blankRecord.setXFIndex(mulBlankRecord.getXFAt(i));
            this.insertCell(blankRecord);
        }
    }

    public void construct(CellValueRecordInterface cellValueRecordInterface, RecordStream recordStream, SharedValueManager sharedValueManager) {
        if (cellValueRecordInterface instanceof FormulaRecord) {
            FormulaRecord formulaRecord = (FormulaRecord)cellValueRecordInterface;
            Class<? extends Record> clazz = recordStream.peekNextClass();
            StringRecord stringRecord = clazz == StringRecord.class ? (StringRecord)recordStream.getNext() : null;
            this.insertCell(new FormulaRecordAggregate(formulaRecord, stringRecord, sharedValueManager));
        } else {
            this.insertCell(cellValueRecordInterface);
        }
    }

    public boolean rowHasCells(int n) {
        if (n >= this.records.length) {
            return false;
        }
        CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[n];
        if (cellValueRecordInterfaceArray == null) {
            return false;
        }
        for (int i = 0; i < cellValueRecordInterfaceArray.length; ++i) {
            if (cellValueRecordInterfaceArray[i] == null) continue;
            return true;
        }
        return false;
    }

    public void visitCellsForRow(int n, RecordAggregate.RecordVisitor recordVisitor) {
        CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[n];
        if (cellValueRecordInterfaceArray == null) {
            throw new IllegalArgumentException("Row [" + n + "] is empty");
        }
        for (int i = 0; i < cellValueRecordInterfaceArray.length; ++i) {
            RecordBase recordBase = (RecordBase)((Object)cellValueRecordInterfaceArray[i]);
            if (recordBase == null) continue;
            int n2 = ValueRecordsAggregate.countBlanks(cellValueRecordInterfaceArray, i);
            if (n2 > 1) {
                recordVisitor.visitRecord(this.createMBR(cellValueRecordInterfaceArray, i, n2));
                i += n2 - 1;
                continue;
            }
            if (recordBase instanceof RecordAggregate) {
                RecordAggregate recordAggregate = (RecordAggregate)recordBase;
                recordAggregate.visitContainedRecords(recordVisitor);
                continue;
            }
            recordVisitor.visitRecord((Record)recordBase);
        }
    }

    private static int countBlanks(CellValueRecordInterface[] cellValueRecordInterfaceArray, int n) {
        CellValueRecordInterface cellValueRecordInterface;
        int n2;
        for (n2 = n; n2 < cellValueRecordInterfaceArray.length && (cellValueRecordInterface = cellValueRecordInterfaceArray[n2]) instanceof BlankRecord; ++n2) {
        }
        return n2 - n;
    }

    private MulBlankRecord createMBR(CellValueRecordInterface[] cellValueRecordInterfaceArray, int n, int n2) {
        int n3;
        short[] sArray = new short[n2];
        for (n3 = 0; n3 < sArray.length; ++n3) {
            sArray[n3] = ((BlankRecord)cellValueRecordInterfaceArray[n + n3]).getXFIndex();
        }
        n3 = cellValueRecordInterfaceArray[n].getRow();
        return new MulBlankRecord(n3, n, sArray);
    }

    public CellValueRecordInterface[] getValueRecords() {
        ArrayList<CellValueRecordInterface> arrayList = new ArrayList<CellValueRecordInterface>();
        for (int i = 0; i < this.records.length; ++i) {
            CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[i];
            if (cellValueRecordInterfaceArray == null) continue;
            for (int j = 0; j < cellValueRecordInterfaceArray.length; ++j) {
                CellValueRecordInterface cellValueRecordInterface = cellValueRecordInterfaceArray[j];
                if (cellValueRecordInterface == null) continue;
                arrayList.add(cellValueRecordInterface);
            }
        }
        CellValueRecordInterface[] cellValueRecordInterfaceArray = new CellValueRecordInterface[arrayList.size()];
        arrayList.toArray(cellValueRecordInterfaceArray);
        return cellValueRecordInterfaceArray;
    }

    public Object clone() {
        throw new RuntimeException("clone() should not be called.  ValueRecordsAggregate should be copied via Sheet.cloneSheet()");
    }
}

