/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import org.geotools.geometry.jts.coordinatesequence.CSBuilder;
import org.geotools.geometry.jts.coordinatesequence.DefaultCSBuilder;

public class CSBuilderFactory {
    private static Class<? extends CSBuilder> defaultBuilderClass;

    public static CSBuilder getDefaultBuilder() {
        try {
            return CSBuilderFactory.getDefaultBuilderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a coordinate sequence builder", e);
        }
    }

    private static Class<? extends CSBuilder> getDefaultBuilderClass() {
        if (defaultBuilderClass == null) {
            defaultBuilderClass = DefaultCSBuilder.class;
        }
        return defaultBuilderClass;
    }

    public static void setDefaultBuilderClass(Class<? extends CSBuilder> builderClass) {
        if (!CSBuilder.class.isAssignableFrom(builderClass)) {
            throw new RuntimeException(builderClass.getName() + " does not implement the CSBuilder interface");
        }
        defaultBuilderClass = builderClass;
    }
}

