/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import org.geotools.util.LazySet;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryFinder;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class JTSFactoryFinder
extends FactoryFinder {
    private static volatile FactoryRegistry registry;

    private JTSFactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(JTSFactoryFinder.class));
        if (registry != null) return registry;
        Class<JTSFactoryFinder> clazz = JTSFactoryFinder.class;
        synchronized (JTSFactoryFinder.class) {
            if (registry != null) return registry;
            FactoryCreator temp = new FactoryCreator(Arrays.asList(GeometryFactory.class));
            temp.registerFactory(new GeometryFactory(), GeometryFactory.class);
            registry = temp;
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static synchronized GeometryFactory getGeometryFactory(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getFactory(GeometryFactory.class, null, hints, Hints.JTS_GEOMETRY_FACTORY);
    }

    public static synchronized GeometryFactory getGeometryFactory() throws FactoryRegistryException {
        return JTSFactoryFinder.getGeometryFactory(null);
    }

    public static synchronized Set<GeometryFactory> getGeometryFactories() {
        return new LazySet<GeometryFactory>(JTSFactoryFinder.getServiceRegistry().getFactories(GeometryFactory.class, null, null));
    }

    public static synchronized PrecisionModel getPrecisionModel(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getFactory(PrecisionModel.class, null, hints, Hints.JTS_PRECISION_MODEL);
    }

    public static synchronized Set<PrecisionModel> getPrecisionModels() {
        return new LazySet<PrecisionModel>(JTSFactoryFinder.getServiceRegistry().getFactories(PrecisionModel.class, null, null));
    }

    public static synchronized CoordinateSequenceFactory getCoordinateSequenceFactory(Hints hints) throws FactoryRegistryException {
        hints = JTSFactoryFinder.mergeSystemHints(hints);
        return JTSFactoryFinder.getServiceRegistry().getFactory(CoordinateSequenceFactory.class, null, hints, Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
    }

    public static synchronized Set<CoordinateSequenceFactory> getCoordinateSequenceFactories() {
        return new LazySet<CoordinateSequenceFactory>(JTSFactoryFinder.getServiceRegistry().getFactories(CoordinateSequenceFactory.class, null, null));
    }

    public static void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    private static final class Registry
    extends FactoryCreator {
        public Registry() {
            super(Arrays.asList(GeometryFactory.class, PrecisionModel.class, CoordinateSequenceFactory.class));
        }

        private static int getSRID(Hints hints) {
            Integer SRID;
            if (hints != null && (SRID = (Integer)hints.get(Hints.JTS_SRID)) != null) {
                return SRID;
            }
            return 0;
        }

        @Override
        protected <T> boolean isAcceptable(T provider, Class<T> category, Hints hints) {
            if (GeometryFactory.class.isAssignableFrom(category)) {
                GeometryFactory factory = (GeometryFactory)provider;
                CoordinateSequenceFactory sequence = factory.getCoordinateSequenceFactory();
                PrecisionModel precision = factory.getPrecisionModel();
                if (!Registry.isAcceptable(sequence, hints.get(Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) || !Registry.isAcceptable(precision, hints.get(Hints.JTS_PRECISION_MODEL))) {
                    return false;
                }
                int SRID = Registry.getSRID(hints);
                if (SRID != 0 && SRID != factory.getSRID()) {
                    return false;
                }
            }
            return super.isAcceptable(provider, category, hints);
        }

        private static boolean isAcceptable(Object actual, Object requested) {
            if (requested == null || requested.equals(actual)) {
                return true;
            }
            if (requested.getClass().isArray()) {
                int length = Array.getLength(requested);
                for (int i = 0; i < length; ++i) {
                    if (Registry.isAcceptable(actual, Array.get(requested, i))) continue;
                    return false;
                }
                return true;
            }
            if (actual != null && requested instanceof Class) {
                Class cast = (Class)requested;
                return cast.isAssignableFrom(actual.getClass());
            }
            return false;
        }
    }
}

