/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class ContentFeatureCollection
implements SimpleFeatureCollection {
    protected static final Logger LOGGER = Logging.getLogger(ContentFeatureCollection.class);
    protected ContentFeatureSource featureSource;
    protected Query query;
    protected SimpleFeatureType featureType;
    protected ContentState state;

    protected ContentFeatureCollection(ContentFeatureSource featureSource, Query query) {
        this.featureSource = featureSource;
        this.query = query;
        this.featureType = featureSource.getSchema();
        if (query.getPropertyNames() != Query.ALL_NAMES) {
            this.featureType = SimpleFeatureTypeBuilder.retype(this.featureType, query.getPropertyNames());
        }
        try {
            if (query.getCoordinateSystemReproject() != null) {
                this.featureType = FeatureTypes.transform(this.featureType, query.getCoordinateSystemReproject());
            } else if (query.getCoordinateSystem() != null) {
                this.featureType = FeatureTypes.transform(this.featureType, query.getCoordinateSystem());
            }
        }
        catch (SchemaException e) {
            LOGGER.log(Level.FINER, "Problem handling Query change of CoordinateReferenceSystem:" + e, e);
        }
        if (!query.getJoins().isEmpty()) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(this.featureType);
            for (Join join : query.getJoins()) {
                try {
                    String typeName = join.getTypeName();
                    tb.userData("JoinedFeatureType", featureSource.getDataStore().getSchema(typeName));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to retrieve the joined feature type");
                }
                tb.add(join.attributeName(), SimpleFeature.class);
            }
            this.featureType = tb.buildFeatureType();
        }
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.featureSource.accepts(this.query, visitor, progress);
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            return new WrappingFeatureIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReferencedEnvelope getBounds() {
        try {
            ReferencedEnvelope result = this.featureSource.getBounds(this.query);
            if (result != null) {
                return result;
            }
            Query q = new Query(this.query);
            ArrayList<String> geometries = new ArrayList<String>();
            for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) continue;
                geometries.add(ad.getLocalName());
            }
            if (geometries.isEmpty()) {
                return new ReferencedEnvelope();
            }
            q.setPropertyNames(geometries);
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.featureSource.getReader(q);){
                ReferencedEnvelope referencedEnvelope;
                while (reader.hasNext()) {
                    SimpleFeature f = reader.next();
                    ReferencedEnvelope featureBounds = ReferencedEnvelope.reference(f.getBounds());
                    if (result == null) {
                        result = featureBounds;
                        continue;
                    }
                    if (featureBounds == null) continue;
                    result.expandToInclude(featureBounds);
                }
                if (result != null) {
                    referencedEnvelope = result;
                    return referencedEnvelope;
                }
                referencedEnvelope = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
                return referencedEnvelope;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int size() {
        try {
            int size = this.featureSource.getCount(this.query);
            if (size >= 0) {
                return size;
            }
            AttributeDescriptor chosen = this.getSmallAttributeInSchema();
            Query q = new Query(this.query);
            if (chosen != null) {
                q.setPropertyNames(Collections.singletonList(chosen.getLocalName()));
            }
            try (FeatureReader<SimpleFeatureType, SimpleFeature> fr = this.featureSource.getReader(q);){
                int count = 0;
                while (fr.hasNext()) {
                    fr.next();
                    ++count;
                }
                int n = count;
                return n;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AttributeDescriptor getSmallAttributeInSchema() {
        AttributeDescriptor chosen = null;
        for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
            if (chosen != null && this.size(ad) >= this.size(chosen)) continue;
            chosen = ad;
        }
        return chosen;
    }

    int size(AttributeDescriptor ad) {
        Class<?> binding = ad.getType().getBinding();
        if (binding.isPrimitive() || Number.class.isAssignableFrom(binding) || Date.class.isAssignableFrom(binding)) {
            return 4;
        }
        if (binding.equals(String.class)) {
            int fieldLen = FeatureTypes.getFieldLength(ad);
            if (fieldLen > 0) {
                return fieldLen * 2;
            }
            return Integer.MAX_VALUE;
        }
        if (Point.class.isAssignableFrom(binding)) {
            return 12;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEmpty() {
        Query notEmptyQuery = new Query(this.query);
        notEmptyQuery.setMaxFeatures(1);
        AttributeDescriptor smallAttribute = this.getSmallAttributeInSchema();
        if (smallAttribute != null) {
            notEmptyQuery.setPropertyNames(Collections.singletonList(smallAttribute.getLocalName()));
        }
        try (FeatureReader<SimpleFeatureType, SimpleFeature> fr = this.featureSource.getReader(notEmptyQuery);){
            boolean bl = !fr.hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ContentFeatureStore ensureFeatureStore() {
        if (this.featureSource instanceof ContentFeatureStore) {
            return (ContentFeatureStore)this.featureSource;
        }
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public SimpleFeatureCollection sort(SortBy sort) {
        Query query = new Query();
        query.setSortBy(sort);
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        Query query = new Query();
        query.setFilter(filter);
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public boolean contains(Object o) {
        try (SimpleFeatureIterator e = this.features();){
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)((Object)e)).close();
            }
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Content is not writable; FeatureStore not available");
    }

    @Override
    public Object[] toArray() {
        ArrayList array = new ArrayList();
        try (SimpleFeatureIterator e = this.features();){
            while (e.hasNext()) {
                array.add(e.next());
            }
            Object[] objectArray = array.toArray(new SimpleFeature[array.size()]);
            return objectArray;
        }
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        try (SimpleFeatureIterator it = this.features();){
            T[] result = array;
            for (int i = 0; it.hasNext() && i < size; ++i) {
                result[i] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
    }

    @Override
    public String getID() {
        return null;
    }

    public static class WrappingFeatureIterator
    implements SimpleFeatureIterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

